import { ACT_STATUS, ACT_STATUS_TOAST, PAGE_MAP } from "@src/utils/constants";
import { makeAutoObservable } from "mobx";
import API from "../api/index";
import { GetCurrSkinId, getCustomShareId } from "@src/utils/utils";
import { initSensors } from "@src/utils/sensorMd";
import { Toast } from "@spark/ui";
import {AESDecrypt, AESEncrypt} from "@src/utils/Crypto";

const skinId = GetCurrSkinId() || getCustomShareId();

const store = makeAutoObservable({
  /** 活动规则 */
  ruleInfo: "",

  /** 前端开发配置 */
  frontVariable: {},

  /** 当前页面 */
  curPage:
    {
      index: PAGE_MAP.HOME_PAGE,
      myPrize: PAGE_MAP.PRIZE_PAGE,
      // 免登中间页-线上测试
      Did1NjA4NjM: PAGE_MAP.MID_PAGE,
      // 免登中间页-线上正式
      Did1NjA4NzE: PAGE_MAP.MID_PAGE,
    }[skinId] || PAGE_MAP.HOME_PAGE,

  pageData: {},

  /** 场景切换 */
  changePage(page, data = {}) {
    this.pageData = data;
    this.curPage = page;
  },

  /** 获取活动规则 */
  async initRule() {
    // 模拟获取远程的数据
    const { data } = await API.getRule();
    this.ruleInfo = data;
  },

  /** 获取前端配置项 */
  async getFrontVariable() {
    // 获取前端开发配置
    const { data } = await API.getFrontVariable();
    const resData = data || {};
    if (resData.shareInfo) resData.shareInfo = JSON.parse(resData.shareInfo);
    this.frontVariable = resData;
    console.log("前端开发配置", data);
  },

  /** 首页信息 */
  homeInfo: {},
  async getHomeInfo() {
    let params = {};
    const shareCode = getUrlParam("shareCode") && getUrlParam("shareCode") !== "null" ? getUrlParam("shareCode") : "";
    if (shareCode) {
      params.shareCode = shareCode;
    }
    const { success, data, timeStamp } = await API.home(params);
    if (success) {
      const resData = data || {};
      const { startTime, endTime } = resData;
      if (timeStamp >= startTime && timeStamp < endTime) {
        resData._actStatus = ACT_STATUS.ING;
      } else if (timeStamp < startTime) {
        resData._actStatus = ACT_STATUS.NOT_START;
      } else {
        resData._actStatus = ACT_STATUS.ENDED;
      }
      this.homeInfo = resData;
      console.log("首页数据", this.homeInfo);
    }
  },
  /**
   * 校验活动状态
   */
  checkActStatus(isSpecial) {
    const { actStartTimestamp, actEndTimestamp, currentTimestamp } = this.homeInfo || {};
    // 活动已结束：【奖品】、【规则】按钮可点
    if (isSpecial && (actEndTimestamp < currentTimestamp)) return true;

    if (actStartTimestamp > currentTimestamp) {
      Toast("活动尚未开始");
      return false;
    }

    if (actEndTimestamp < currentTimestamp) {
      Toast("活动已经结束");
      return false;
    }
    return true;
  },

  startInfo: {},
  async startTest() {
    const { success, data } = await API.startAnswer();
    if (success) {
      const txt = AESDecrypt(data, "1c5f9cab3460e316", "cDOiBC1n2QrkAY2P");
      this.startInfo = JSON.parse(txt);
      this.changePage(PAGE_MAP.LIFE_SETTING_PAGE);
    }
  },
  async submitTest(param) {

    param.recordId = this.startInfo.recordId;
    param.timestamp = Date.now();

    const paramEn = AESEncrypt(
      JSON.stringify(param),
      "1c5f9cab3460e316",
      "cDOiBC1n2QrkAY2P",
    );

    const { success, data } = await API.submitAnswer({
      param: paramEn,
    });

    if (success) {
      this.changePage(PAGE_MAP.RESU_PAGE, {
        ...data,
        funds: param.resultAmount,
        score: param.score,
      });
    }
  },

  userInfo: {},
  setUserInfo(userInfo) {
    this.userInfo = userInfo;
  },
  /** 初始化神策埋点 */
  async initSensorsMd() {
    const res = await API.queryUserInfo();
    if (res.success) {
      store.setUserInfo(res.data || {});
      const { unionId, openId, friendEmpNo, friendOpenId, newEmpNo } = res.data || {};
      // initSensors(unionId, openId, friendEmpNo, friendOpenId);
      initSensors(unionId, openId, newEmpNo, res.data);
    }
  },
});
export default store;
