import React from "react";
import {observer} from "mobx-react";
import "./answerpage.less";
import {_asyncThrottle, _throttle, waitTime} from "@src/utils/utils";
import {Button} from "@src/components/Button";
import {QuestionCfg} from "@src/pages/answerpage/QuestionCfg";
import classNames from "classnames";
import modalStore from "@src/store/modal";
import store from "@src/store";
import { sensorMdClick, sensorMdExpouse } from "@src/utils/sensorMd";

@observer
class Answerpage extends React.Component {
  state = {
    funds: 0,
    quesIndex: 0,
    chooseIndex: null,
  };

  selectOptions = [];
  initFunds = 0;
  componentDidMount() {
    this.initFunds = this.props.funds;
    this.setState({
      funds: this.props.funds,
    })
    sensorMdExpouse("activityPage", { pageName: "测试选择页" });
  }

  clickItem(index) {
    this.setState({
      chooseIndex: index,
    });
  }

  clickNext = () => {
    sensorMdClick("activityClick", { pageName: "测试选择页", buttonName: "确认" });
    const {quesIndex, chooseIndex, funds} = this.state;

    if (chooseIndex == null) return;

    this.selectOptions.push(chooseIndex);

    const {event, review} = QuestionCfg[quesIndex].answer[chooseIndex];

    const resultFunds = this.state.funds + event.money;

    modalStore.pushPop("EventPanel", {
      event,
      call: async () => {
        if (this.state.quesIndex == 5) {

          let score = 1;
          if (resultFunds >= 100) {
            score = 4;
          } else if (resultFunds > 50) {
            score = 3;
          } else if (resultFunds > 0) {
            score = 2;
          }
          await store.submitTest({
            initParams: this.props.settingParams,
            initAmount: this.initFunds,
            selectOptions: this.selectOptions.map((item) => item + 1),
            resultAmount: resultFunds,
            score,
          });
          return;
        }

        modalStore.pushPop("ReviewPanel", {review: QuestionCfg[quesIndex].review});
        this.setState({
          chooseIndex: null,
          quesIndex: this.state.quesIndex + 1,
          funds: resultFunds,
        });
      }
    });
  }

  render() {
    const {quesIndex, chooseIndex, funds} = this.state;

    const {stage, bg, titleImg, answer} = QuestionCfg[quesIndex];

    // 当前题目
    return <div className="answerpage modal_center">
      <div
        className="bg"
        style={{
          backgroundImage: `url(${bg})`,
        }}
      />

      <div className="stage">{stage}</div>

      <div className="fundsArea">
        <div className="funds">当前资金：<span>{funds}</span>万</div>
      </div>

      <div className="quesArea">
        <div className="queIndex">
          <span>{quesIndex + 1}</span>
          <text>/</text>
          6
        </div>
        <div className="questionArea">
          <img
            src={titleImg}
            style={{
              transformOrigin: 'top left',
              transform: `scale(${window.remScale}) translateY(50%)`
            }}
          />
        </div>

        <div className="answerArea">
          {answer.map((item, index) => {
            const cls = classNames(
              "answerItem",
              {
                active: index === chooseIndex,
              }
            );
            return <div
              className={cls}
              onClick={this.clickItem.bind(this, index)}
            >{item.txt}</div>
          })}
        </div>
      </div>
      <Button className="confirm" onClick={this.clickNext}/>
    </div>;
  }
}

export default Answerpage;
