
import { objectAssign } from '@spark/utils';
import sensors from 'sa-sdk-javascript';
import { ACTIVITY_SOURCE_CHANNEL, SYS_SOURCE_CHANNEL } from './constants';
import pageleave from './pageleave';

export const initSensors = (uid, openId, newEmpNo, userInfo) => {
  sensors.init({
    server_url: CFG.sensorUrl,
    is_track_single_page: true,
    show_log: true,
    heatmap: {
      clickmap: 'default',
      scroll_notice_map: 'not_collect',
      collect_tags: {
        div: true
      },
    },
  });

  sensors.login(uid);

  const shareTypeMap = {
    1: "客户邀请",
    2: "业务员邀请"
  }
  const skinId = getUrlParam("skinId");
  // 本次没区分业务员/客户 就null
  const shareType = !!skinId ? shareTypeMap[skinId] : null;

  const publicObjec = objectAssign({
    currentUrl: location.href,
    referrer: document.referrer,
    activityId: "25GuardingLife",
    unionid: uid,
    openid: openId,
    source: CFG.channel,
    systemName: '寿险2013版微信公众平台',
    userSource: null,
    userAccount: CFG.channel == 'taihaodian' ? '太好店小程序' : '太平洋寿险小程序',
    activityName: CFG.activityName,
    c_date: "2025/08/01-2025/08/24",
    empNp: newEmpNo, // 用户实际绑定业务员工号(与转发无关)
    activitySource: ACTIVITY_SOURCE_CHANNEL[CFG.channel] || "",
    sysSourceName: SYS_SOURCE_CHANNEL[CFG.channel] || "",
    friendDistinctId: getUrlParam("uid") || "", // 转发人unionId
    shareMark: !!getUrlParam("uid") ? "是" : "否",
    shareType: shareType,
    friendEmpNo: getUrlParam("shareNewEmpNo"), // 邀请人的业务员工号(A转发给B,传A的业务员工号)
    friendOpenId: getUrlParam("shareOpenId"), // 邀请人的openId
    empno: CFG.empno,

    miniopenid: userInfo?.miniopenid || '',
    phone: userInfo?.phone || '',
    wxNickName: userInfo?.nickname || '',
    sex: userInfo?.sex || '',
    age: userInfo?.age || '',
    userLevel: userInfo?.userLevel || '',
    subscribeFlg: userInfo?.subscribeFlg || false,
    subscribeFlg2: userInfo?.subscribeFlg2 || false,
    officerOrEmp: userInfo?.officerOrEmp || '',
    programLogin: userInfo?.programLogin || '',
    province: userInfo?.province || '',
    memberAttribution: userInfo?.memberAttribution || '',
    memberType: userInfo?.memberType || '',
    memberLevel: userInfo?.customLevel || '',

    functionalpartition: "活动板块"

  }, window['__tbSensorsObj__']);
  sensors.registerPage(publicObjec);
  sensors.quick('autoTrack');
};

export const pageLeave = (pagaName, duration) => {
  sensors.use(pageleave, {
    custom_props: {
      pagaName
    },
    heartbeat_intervaltime: duration,
    max_duration: duration * 24 * 60 * 60,
    isCollectUrl: function (url) {
      return true
    }
  })
}

/**
 * 页面曝光埋点
 * @param {string} eventName
 * @param {{pageName:string,activityName:string,prize:string}} option
 */
export const sensorMdExpouse = (eventName, option) => {
  sensors.track(eventName, option);
};

/**
 * 页面点击埋点
 * @param {string} eventName
 * @param {{pageName:string,activityName:string,buttonName:string,prize:string}} option
 */
export const sensorMdClick = (eventName, option) => {
  sensors.track(eventName, option);
};
