"use strict";

import React from "react";
import { observer } from "mobx-react";
import "./sharepage.less";
import { getUrlParam, isMiniprogram } from "@src/utils/utils";
import API from "@src/api";
import store from "../../store";
import { LOG_KEY, MatterViewDuration, MatterViewOpt, sensorLog } from "../../utils/sensors";
import shareStore from "@src/store/share";
import { Button } from "@src/components/Button";
import { accessLog } from "duiba-utils";
@observer
class Sharepage extends React.Component {

  state = {
    shareInfo: {},
  };

  constructor(props) {
    super(props);

    this.shareRef = null;
    this.startTime = +new Date();
  }

  async componentDidMount() {
    // accessLog(506)

    accessLog("505", {
      from: CFG.channel
    });

    await store.checkBindStatus();
    API.outside();
    // await this.getShareInfo();
    MatterViewOpt("b12850", {
      page_name: "分享落地页",
    });
    if (getUrlParam("inviteCode")) {
      sensorLog(LOG_KEY.exposure, "b12850", "d12851", {
        button_name: "立即为TA助力按钮",
        page_name: "分享落地页",
      });
    } else {
      sensorLog(LOG_KEY.exposure, "b12850", "d12852", {
        button_name: "立即参与按钮",
        page_name: "分享落地页",
      });
    }
    // setTimeout(() => {
    //   this.shareRef.scrollTo(0, 70)
    // }, 50)
  }

  componentWillUnmount() {
    MatterViewDuration("b12850", +new Date() - this.startTime,{
      page_name: "分享落地页",
    });
  }

  getShareInfo = async () => {
    const { success, data } = await API.coop_getLoadingInfo();
    if (success && data) {
      this.setState({
        shareInfo: data,
      });
    }
    // if (!data?.validUid) {
    //   modalStore.pushPop("Loginpop")
    // }
  };

  /** 跳转微信端活动 */
  toWeActHandle = () => {

    API.outside();

    let indexUrl = CFG.indexUrl
    MatterViewDuration("b12850", +new Date() - this.startTime);
    if (getUrlParam("inviteCode")) {
      sensorLog(LOG_KEY.click, "b12850", "d12851", {
        button_name: "立即为TA助力按钮",
        page_name: "分享落地页",
      });
    } else {
      sensorLog(LOG_KEY.click, "b12850", "d12852", {
        button_name: "立即参与按钮",
        page_name: "分享落地页",
      });
    }

    if (getUrlParam("inviteCode")) {
      shareStore.doAssist();
    }


    CFG.workerCode = getUrlParam("ykCode");
    if(isMiniprogram()){ //小程序域名写死
      CFG.domain = "https://96094-activity.dexfu.cn";
    }else{
      CFG.domain = location.origin
    }
    let url =
      CFG.domain +
      indexUrl +
      "&channel=" +
      CFG.channel +
      `${!!getUrlParam("inviteCode") ? "&inviteCode=" + getUrlParam("inviteCode") : ""}` +
      `${!!CFG.workerCode ? `&ykCode=${CFG.workerCode}` : ""}` +
      `&agentCode=${CFG.agentCode || ""}&actPlatforms=${CFG.actPlatforms || ""}&actId=${CFG.actId || ""}`;
      // alert(url)
    location.href = url;
  };

  judgeBtn = () => {
    const inviteCode = getUrlParam("inviteCode")

    if(inviteCode) {
      return <Button className="assist_btn md30" onClick={this.toWeActHandle} />;
    } else {
      return <Button className="normal_btn md31" onClick={this.toWeActHandle} />;
    }
  }

  render() {
    const inviteCode = getUrlParam("inviteCode");

    return (
      <div className="sharepage_wrap" ref={(r) => (this.shareRef = r)}>
        <div className="sharepage modal_center">
          <span className="bg" />
          {!!inviteCode && <span className="invite_text"/>}
          {this.judgeBtn()}
        </div>
      </div>
    );
  }
}
export default Sharepage;
