import React from "react";
import { observer } from "mobx-react";
import "./NoPrizeCard.less";
import { Button } from "@src/components/Button";
import modalStore from "@src/store/modal";
import { SvgaPlayer } from "@spark/svgaplayer";
import { RES_PATH } from "../../../sparkrc";
import { Swiper } from "antd-mobile";
import { LOG_KEY, pageView, sensorLog } from "@src/utils/sensors";
import { _throttle, randomNum } from "@src/utils/utils";

@observer
class NoPrizeCard extends React.Component {

  state = {
    card: true,
  };

  componentDidMount() {

    pageView("b12137", {
      page_name: "祝福语翻转页",
    });
    sensorLog(LOG_KEY.exposure, "b12137", "d12138", {
      page_name: "祝福语翻转页",
      button_name: "点击切换有惊喜按钮",
    });
  }

  /** card1文本选择 */
  opt1 = () => {
    const list = [
      'NoPrizeCard/text1.png',
      'NoPrizeCard/text2.png',
      'NoPrizeCard/text3.png',
      'NoPrizeCard/text4.png'
    ]
    const address = list[randomNum(0, 4)]
    return address
  }

  /** 切换按钮*/
  clickExchange1 = () => {
    sensorLog(LOG_KEY.click, "b12137", "d12138", {
      page_name: "祝福语翻转页",
      button_name: "点击切换有惊喜按钮",
    });
    this.setState({
      card: false,
      svg: true
    });

    setTimeout(() => {
      this.setState({
        svg: false,
        card: false,
      });
    }, 2000)

  };


  /** 关闭按钮*/
  clickClose = _throttle(() => {
    modalStore.closePop();
  });

  render() {
    const { card } = this.state;
    const { data } = this.props.popData;
    console.log(data, 123123);
    return <div className="NoPrizeCard modal_center">
      {
        card === true ?
          //翻转前
          <div className="card1">
            <SvgaPlayer className="bg" src={RES_PATH + "svga/5输出展开.svga"} loop={1} />
            <span className="picture"></span>
            <img className="text" src={RES_PATH + this.opt1()} />
          </div>
          //翻转后
          : <div>
            <SvgaPlayer className="bg" src={RES_PATH + "svga/6输出切换.svga"} loop={1} />
            <Swiper className="prodSwiper"
              indicatorProps={{ style: { display: "none" } }}
            >
              {
                data?.productInfos?.map((item, index) => {
                  return <Swiper.Item className="prodItem" key={index}>
                    <span className="line"></span>
                    <img className="picture2"
                      src={item?.productImg}
                      alt={item?.productText}
                    />
                    <div className="txt">
                      {item?.productText}
                    </div>
                  </Swiper.Item>
                })
              }
            </Swiper>
            {/* <Button className="exchange2" /> */}
          </div>
      }

      {
        card === true && <Button className="exchange1 md27" onClick={this.clickExchange1} />
      }


      <Button className="close md28" onClick={this.clickClose} />
    </div>;
  }
}

export default NoPrizeCard;
