import React from "react";
import { observer } from "mobx-react";
import "./CarvePanel.less";
import { Button } from "@src/components/Button";
import modalStore from "@src/store/modal";
import store from "@src/store";
import { SvgaPlayer } from "@spark/svgaplayer";
import { RES_PATH } from "../../../sparkrc";

@observer
class CarvePanel extends React.Component {

  componentDidMount = async () => {

  };

  /** 关闭 */
  clickClose = () => {
    modalStore.closePop();
  };

  clickOk = () => {
    modalStore.closePop();
  }

  render() {
    return <div className="CarvePanel modal_center">
      <SvgaPlayer className="effect" src={RES_PATH + "svga/4输出弹窗氛围.svga"}/>
      <div className="bg"/>
      <div className="txt">一共有{store.setIndex.newAssistUser}位好友助力</div>
      <Button className="btn md13" onClick={this.clickOk} />
      <Button className="close" onClick={this.clickClose} />
    </div>;
  }
}

export default CarvePanel;
