import { generateAPI } from "./utils.js";

const API = generateAPI({
  /** 获取活动规则 */
  getRule: "projectRule.query",
  /** 获取前端配置项 */
  getFrontVariable: "coop_frontVariable.query",
  /** 参与接口 post请求 */
  doJoin: {
    uri: "join.do",
    method: "post"
  },
  /** 签到 */
  doSign: {
    uri: "checkin_1/doSign.do",
    withToken: true,  // 携带token
  },

  // cookie丢失-临时保存cookie
  tempSaveCookie: {
    uri: "/autoLogin/tempSaveCookie",
    showMsg: false,
  },
  // cookie丢失-重新设置cookie
  resetCookie: "/autoLogin/resetCookie",
  userLogin: {
    uri: "userLogin.check",
    showMsg: false,
  },
  buriedPoint: {
    uri: "home/buriedPoint.do",
    showMsg: false,
  },

  /** 获取任务列表 */
  getTaskInfo: {
    uri: "task_1/queryTasks.do",
  },
  /** 完成任务 */
  doCompleted: {
    uri: "task_1/doCompleted.do",
    method: "post",
    withToken: true,
  },
  /** 领取奖励 */
  sendPrize: {
    uri: "task_1/sendPrize.do",
    method: "post",
    withToken: true,
  },
  /** 绑定友客业务员信息接口 */
  bindYk: {
    uri: "agent/bindYk.do",
    method: "post",
    showMsg: false,
  },
  /** 生成唤端二维码 */
  getLongLinkQrcode: `/customActivity/qrcode/getQrcode`,

  // /** 获取邀请码 */
  // getInviteCode: {
  //   uri: "customInvite1/getInviteCode.do",
  //   method: "post",
  //   withToken: true,
  // },
  // /** 助力 */
  // doAssist: {
  //   uri: "customInvite1/doAssist.do",
  //   method: "post",
  //   withToken: true,
  //   showMsg: false,
  // },
  /** 落地页 */
  coop_getLoadingInfo: "customInvite1/outside.do",
  /** 获取地区 */
  getParentCode: "/gaw/address/getChildrenByParentCode",
  /** 抽奖首页 */
  drawIndex: "draw/index.do",
  /** 抽奖 */
  drawJoin: {
    uri: "draw/doDraw.do",
    withToken: true,
  },

  /** 校验验证码并登录 */
  coopCheckCode: {
    uri: "examine/coop_checkCode.do",
    method: "post",
  },

  getCode: {
    uri: "/customActivity/piccLife/sendSmsCode",
    // showMsg: false,
  },

  /** 发送验证码 */
  coopSendCode: {
    uri: "examine/coop_sendCode.do",
    method: "post",
  },
  /** 校验是否绑定手机号 */
  checkBind: "/customActivity/piccLife/check",
  /** 奖品页 */
  prize: "/crecord/getrecordmn",

  /** 助力 */
  doAssist: {
    uri: "inviteAssist_1/doAssist.do",
    method: "post",
    withToken: true,
    showMsg: false,
  },
  /** 获取邀请码 */
  getInviteCode: {
    uri: "inviteAssist_1/getInviteCode.do",
    method: "post",
    withToken: true,
  },
  queryInviteRecords: "inviteAssist_1/queryInviteRecords.do",

  // 推送使用
  outside: {
    uri: `inviteAssist_1/outside.do`,
    widthToken: true,
  },

  // 推送使用
  assistJoin: {
    uri: `inviteAssist_1/join.do`,
    widthToken: true,
  },

  bindPhone: {
    uri: "/customActivity/piccLife/bindWithCode",
    method: "post",
    showMsg: false,
  },

////////////////////////////////////////////////////////

  index: "main/index.do",

  /** 同意隐私协议接口*/
  agreePrivacy: "main/agreePrivacy.do",

});

// console.log('======', API)

export default API;
