import { PAGE_MAP } from "@src/utils/constants";
import { makeAutoObservable } from "mobx";
import API from "../api/index";
import { GetCurrSkinId, getCustomShareId, getUrlParam, waitTime } from "@src/utils/utils";
import { Toast } from "@spark/ui";
import modalStore from "@src/store/modal";
import shareStore from "./share";
import ReviewSucPop from "@src/components/ReviewSucPop/ReviewSucPop";
import RankNoPrizePop from "@src/components/RankNoPrizePop/RankNoPrizePop";

const skinId = GetCurrSkinId() || getCustomShareId();

const store = makeAutoObservable({
  /** 活动规则 */
  ruleInfo: "",

  /** 前端开发配置 */
  frontVariable: {},

  /** 当前页面 */
  curPage: (CFG.agentShare == "1" ? PAGE_MAP.AGENT_SHARE_PAGE : null) || {
    // TODO 举例子，自定义页面，因为mng更新原因原数字id会对应一个新的字符串id
    "5055": "sharePage",
    Did1NDA0NDc: "sharePage",
    prize: PAGE_MAP.PRIZE_PAGE,
    sharepage: PAGE_MAP.SHARE_PAGE,
    index: PAGE_MAP.HOME_PAGE,
    workPage: PAGE_MAP.OPUS_PAGE,
  }[skinId] || PAGE_MAP.HOME_PAGE,

  pageData: {},

  /** 绑定友客业务员 */
  async bindYkCode(code) {
    const res = await API.bindYk({
      code: code,
    });
    return res;
  },
  //分享活动
  shareAct() {
    shareStore.doShare();
  },

  /** 场景切换 */
  changePage(page, data = {}) {
    this.pageData = data;
    this.curPage = page;
  },
  homeInfo: {},
  /** 获取首页信息 */
  async getHomeInfo() {
    const resp = await API.getHomeInfo();

    if (resp.success) {
      this.homeInfo = resp.data;
      // todo 首页接口把绑定逻辑加上
      /** 绑定业务员code判断 */
      if (data?.boundYkCode) {
        // 已绑定
        if (resp?.data?.agent) {
          CFG.workerCode = resp?.data?.agentCode;
        } else {
          CFG.workerCode = resp?.data?.boundYkCode;
        }
      } else {
        // 未绑定 从链接上取-无论是否有都要调用
        if (!resp?.data?.agent) {
          /**后端说增加非业务员才调用 */
          const { success: success1, data: data1 } = await this.bindYkCode(CFG.workerCode || "");

          if (success1 && data1?.code) {
            CFG.workerCode = data1?.code;
          }
        } else {
          CFG.workerCode = resp?.data?.agentCode;
        }
      }
    }
  },

  /** 获取活动规则 */
  async initRule() {
    // 模拟获取远程的数据
    const { data } = await API.getRule();
    this.ruleInfo = data;
  },

  /** 获取前端配置项 */
  async getFrontVariable() {
    // 获取前端开发配置
    const { data } = await API.getFrontVariable();
    this.frontVariable = data || {};
    console.log("前端开发配置", data);
  },
  /** 绑定手机号接口返回状态 */
  isApiCheckBack: false,
  setIsApiCheckBack(status) {
    this.isApiCheckBack = status;
  },
  /** 校验是否绑定手机号 */
  async checkBindStatus() {
    const { success, data } = await API.checkBind({
      appId: getUrlParam("appId"),
      dbredirect: encodeURIComponent(window.location.href),
    });
    console.info("%c data", "font-size: 30px", data);
    if (success && data) {
      if (data?.bind) {
        if (data?.url) {
          location.replace(data?.url);
        } else {
          // 已经绑定过，跳转完后端返回的免登链接时，展示页面
          this.setIsApiCheckBack(true); // 助力
          return true;
        }
      } else {
        this.setIsApiCheckBack(true);
        modalStore.pushPop("LoginPop");
      }
      await waitTime(200);
    }
    return false;
  },


  setIndex: {},
  /** 首页 */
  async getSalesManIndex() {
    const { success, data } = await API.salesManIndex();
    if (!success) return;
    this.setIndex = data || {};


    if (!data.guideFlag && data?.agent) {
      modalStore.pushPop("GuidePop");
    }

    if (data?.ruleGuidePopFlag) {
      modalStore.pushPop("RulePop");
    }

    // 首页接口把绑定逻辑加上
    /** 绑定业务员code判断 */
    if (data?.boundYkCode) {
      // 已绑定
      if (data?.agent) {
        CFG.workerCode = data?.agentCode;
      } else {
        CFG.workerCode = data?.boundYkCode;
      }
    } else {
      // 未绑定 从链接上取-无论是否有都要调用
      if (!data?.agent) {
        /**后端说增加非业务员才调用 */
        const { success: success1, data: data1 } = await this.bindYkCode(CFG.workerCode || "");

        if (success1 && data1?.code) {
          CFG.workerCode = data1?.code;
        }
      } else {
        CFG.workerCode = data?.agentCode;
      }
    }

    //  审核弹窗
    if (this.setIndex?.examinePop?.needPop) {
      if (this.setIndex?.examinePop.result) {
        modalStore.pushPop("ReviewSucPop", { data: this.setIndex?.examinePop?.sendDrawNum });
      } else {
        modalStore.pushPop("ReviewFailedPop");
      }
    }

    // 排行榜弹窗
    if (this.setIndex?.rankPop?.needPop) {
      if (this.setIndex?.rankPop.result) {
        modalStore.pushPop("RankPrizePop", { data: this.setIndex?.rankPop });
      } else {
        modalStore.pushPop("RankNoPrizePop", { data: this.setIndex?.rankPop });
      }
    }
  },

  /**   判断活动时间 */
  checkActTime(type) {
    const { actStartTime, currentTime, actEndTime } = this.setIndex;
    if (currentTime < actStartTime && !["rule", "prize"].includes(type)) {
      Toast("活动未开始");
      return false;
    }
    if (currentTime > actEndTime && !["rule", "prize"].includes(type)) {
      Toast("活动已结束");
      return false;
    }
    return true;
  },

  setExamineIndex: {},
  /**   审核首页 */
  async getExamineIndex() {
    const { success, data } = await API.examineIndex();
    if (!success) return;
    this.setExamineIndex = data || {};
  },

  setProductSearch: {},
  /**   作品排行榜 */
  async getProductSearch(workNum = "") {
    const { success, data } = await API.productSearch({ content: workNum });
    if (!success) return;
    this.setProductSearch = data || {};
  },


  workDetailNum: getUrlParam("worksNum"),//作品详情页作品编号
  opusInfo: {},
  endOpus: false,
  async getOpusInfo() {
    this.endOpus = false
    const { success, data } = await API.workDetail({ worksNum: this.workDetailNum });
    if (success) {
      this.opusInfo = data;
      this.nowPage = 1;
      this.commentInfo = [];
      this.getCommentInfo(1);
    }
    this.endOpus = true
  },
  commentInfo: [],
  totalPage: 0,
  nowPage: 1,
  timeStamp: 0,
  async getCommentInfo(pageNum) {
    const { success, data, timeStamp } = await API.commentRecords({ worksNum: this.workDetailNum, pageNum, pageSize: 20 });
    if (success) {
      this.timeStamp = timeStamp;
      this.commentInfo = this.commentInfo.concat(data.list);
      this.totalPage = data.totalPage;
      this.nowPage = pageNum;
    }
  },
  async doComment(content) {
    const { success, data } = await API.comment({ worksNum: this.workDetailNum, content });
    if (success) {
      modalStore.closePop("Commentpop");
      Toast("发送成功~");
      this.getOpusInfo();
    }
  },
  async doThumbsUp() {
    const { success, data } = await API.thumbsUp({ worksNum: this.workDetailNum });
    if (success) {
      modalStore.pushPop("Pointsucpop", data.awardDrawTimes);
    }
  },
});


export default store;
