"use strict";

import React from "react";
import { observer } from "mobx-react";
import "./userhomepage.less";
import store from "@src/store";
import { _asyncThrottle, _throttle, dateFormatter } from "@src/utils/utils";
import modalStore from "@src/store/modal";
import { PAGE_MAP, emojiReg, specialStrReg } from "@src/utils/constants";
import musicStore from "@src/store/musicStore";
import { Button } from "@src/components/Button";
import { SvgaPlayer } from "@spark/svgaplayer";
import { RES_PATH } from "../../../sparkrc";
import { LOG_KEY, pageView, sensorLog } from "@src/utils/sensors";

@observer
class Userhomepage extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      workNum: "",
    };
  }

  async componentDidMount() {
    await store.getProductSearch();
    pageView("b12094", {
      page_name: "用户端-活动首页",
    });
    sensorLog(LOG_KEY.exposure, "b12094", "d12095", {
      page_name: "用户端-活动首页",
      button_name: "规则按钮",
    });
    sensorLog(LOG_KEY.exposure, "b12094", "d12096", {
      page_name: "用户端-活动首页",
      button_name: "奖品按钮",
    });
    sensorLog(LOG_KEY.exposure, "b12094", "d12097", {
      page_name: "用户端-活动首页",
      button_name: "抽奖按钮",
    });
    sensorLog(LOG_KEY.exposure, "b12094", "d12098", {
      page_name: "用户端-活动首页",
      button_name: "赚点赞次数按钮",
    });
    sensorLog(LOG_KEY.exposure, "b12094", "d12098", {
      page_name: "用户端-活动首页",
      button_name: "赚点赞次数按钮",
    });
    sensorLog(LOG_KEY.exposure, "b12094", "d12099", {
      page_name: "用户端-活动首页",
      button_name: "搜索作品按钮",
    });
    sensorLog(LOG_KEY.exposure, "b12094", "d12100", {
      page_name: "用户端-活动首页",
      button_name: "我的点赞按钮",
    });
  }

  /** 规则按钮*/
  clickRule = () => {
    sensorLog(LOG_KEY.click, "b12094", "d12095", {
      page_name: "用户端-活动首页",
      button_name: "规则按钮",
    });
    if (!store.checkActTime("rule")) return;
    modalStore.pushPop("RulePop");
  };
  /** 奖品按钮*/
  clickPrize = () => {
    sensorLog(LOG_KEY.click, "b12094", "d12096", {
      page_name: "用户端-活动首页",
      button_name: "奖品按钮",
    });
    if (!store.checkActTime("prize")) return;
    if (!store.setIndex?.agreeFlag) {
      modalStore.pushPop("Yinsirulepop");
      return;
    }
    store.changePage(PAGE_MAP.PRIZE_PAGE, { from: PAGE_MAP.USER_HOME_PAGE });
  };
  /** 暂停音乐按钮*/
  toStop = () => {
    if (!store.checkActTime()) return;
    musicStore.changeMusicStatus();
  };
  /** 播放音乐按钮*/
  toPlay = () => {
    if (!store.checkActTime()) return;
    musicStore.changeMusicStatus();
  };
  /** 任务按钮*/
  clickTask = () => {
    sensorLog(LOG_KEY.click, "b12094", "d12098", {
      page_name: "用户端-活动首页",
      button_name: "赚点赞次数按钮",
    });
    if (!store.checkActTime()) return;
    modalStore.pushPop("Taskpop");
  };
  /** 抽奖按钮*/
  clickDraw = () => {
    sensorLog(LOG_KEY.click, "b12094", "d12097", {
      page_name: "用户端-活动首页",
      button_name: "抽奖按钮",
    });
    if (!store.checkActTime()) return;
    store.changePage(PAGE_MAP.DRAW_PAGE);
  };
  /** 点赞明细按钮*/
  clickLikeDetail = () => {
    sensorLog(LOG_KEY.click, "b12094", "d12100", {
      page_name: "用户端-活动首页",
      button_name: "我的点赞按钮",
    });
    if (!store.checkActTime()) return;
    store.changePage(PAGE_MAP.LIKE_LOG_PAGE);
  };
  onNumInput = (e) => {
    let value = e.target.value;
    value = value.replace(emojiReg, "");
    value = value.replace(specialStrReg, "").replace(/\s+/g, "");
    this.setState({
      workNum: value,
    });
  };

  search = _asyncThrottle(() => {
    sensorLog(LOG_KEY.click, "b12094", "d12099", {
      page_name: "用户端-活动首页",
      button_name: "搜索作品按钮",
    });
    const { workNum } = this.state;
    // if (!workNum) return;
    store.getProductSearch(workNum);
  }, 1000);

  clickDetails = _throttle((workNum) => {
    if (!store.checkActTime()) return;
    store.workDetailNum = workNum;
    store.changePage(PAGE_MAP.OPUS_PAGE)
  })

  render() {
    const { setIndex, setProductSearch } = store;
    const { workNum } = this.state;
    return (
      <div className="com_Container">
        <div className="userhomepage">
          <span className="bg"></span>
          <SvgaPlayer className="svga1" src={`${RES_PATH}userHomePage/3输出首页氛围.svga`}></SvgaPlayer>
          <span className="diaologBg"></span>
          {musicStore?.status ? (
            <Button className="music_open md25" onClick={this.toStop} />
          ) : (
            <Button className="music_close md25" onClick={this.toPlay} />
          )}
          <div className="productbox">
            {setProductSearch?.rankInfos?.length > 0 ? (
              setProductSearch?.rankInfos?.map((item, index) => {
                return (
                  <div className="productitem" key={"rank" + index}>
                    <span className="produtbg"></span>
                    <span className="produtImg" onClick={this.clickDetails.bind(this,item?.worksNum)}>
                      <img src={item?.worksImg} alt="" />
                    </span>
                    <span className="pictureList_item_bianhaoBg"></span>
                    <span className="produtRankBg"></span>

                    <span className="productrank">第{item?.rank}名</span>
                    <span className="productnum">作品编号：{item?.worksNum}</span>
                    <span className="producttitle textover">{item?.worksTitle}</span>
                    <div className="likenumbox">
                      <span className="likenum">{item?.thumbsNum > 999999 ? "999999+" : item?.thumbsNum}</span>
                      <span className="likenum_icon"></span>
                    </div>
                    {item?.sex == 1 && <span className="sex1_icon"></span>}
                    {item?.sex == 2 && <span className="sex2_icon"></span>}
                  </div>
                );
              })
            ) : (
              <div className="nothing" />
            )}
          </div>
          <span className="acttime">
            活动时间：{dateFormatter(setIndex?.actStartTime, "yyyy年MM月dd")} -{" "}
            {dateFormatter(setIndex?.actEndTime, "MM月dd号")}
          </span>
          <span className="mylastlikenum">
            我的点赞次数：{setProductSearch?.remainThumbsTimes > 9999 ? "9999+" : setProductSearch?.remainThumbsTimes}
          </span>
          <Button className="mylike_btn md28" onClick={this.clickLikeDetail}></Button>
          <div className="searchbox">
            <input
              className="search_bg inputStyle"
              placeholder="搜索作品编号"
              value={workNum}
              maxLength={50}
              onChange={this.onNumInput}></input>
          </div>
          <span className="prizename">
            每点赞1次可获得1次抽奖机会
            <br />
            有机会抽取{setIndex?.awardDesc}
          </span>
          <div className="useridbox">
            <span className="useridbg"></span>
            <span className="userid">用户ID：{setIndex?.uid}</span>
          </div>
          <Button className="task_btn md27" onClick={this.clickTask}></Button>
          <Button className="rule_btn md24" onClick={this.clickRule}></Button>
          <Button className="prize_btn md23" onClick={this.clickPrize}></Button>
          <span className="search_btn"></span>
          <span className="search_icon" onClick={this.search}></span>
          <Button className="draw_btn md26" onClick={this.clickDraw}></Button>
        </div>
      </div>
    );
  }
}
export default Userhomepage;
