"use strict";

import React from "react";
import { observer } from "mobx-react";
import "./sharepage.less";
import { dateFormatter, getUrlParam, isMiniprogram, windowJumpUrl } from "@src/utils/utils";
import API from "@src/api";
import { handleLogClick, handleLogExposure } from "../../../MD";
import store from "../../store";
import { LOG_KEY, MatterShareOpt, MatterViewDuration, MatterViewOpt, pageView, pageViewD, sensorLog } from "../../utils/sensors";
import { extranceName } from "../../utils/constants";
import { isFlowCancellationError } from "mobx";
@observer
class Sharepage extends React.Component {
  constructor(props) {
    super(props);

    this.state = {
      shareInfo: {},
    };

    this.shareRef = null;
    this.startTime = +new Date();
  }

  async componentDidMount() {
    // accessLog(506)
    await store.checkBindStatus();
    API.outside();
    // await this.getShareInfo();
    MatterViewOpt("b12112", {
      page_name: "分享落地页",
    });
    if (getUrlParam("inviteCode")) {
      sensorLog(LOG_KEY.exposure, "b12112", "d12113", {
        button_name: "为TA助力按钮",
        page_name: "分享落地页",
        entrance: extranceName[CFG.channel],
      });
    } else if(getUrlParam("worksNum")){
      sensorLog(LOG_KEY.exposure, "b12112", "d12116", {
        button_name: "为TA点赞按钮",
        page_name: "分享落地页",
        entrance: extranceName[CFG.channel],
      });
    } else {
      sensorLog(LOG_KEY.exposure, "b12112", "d12114", {
        button_name: "立即参与按钮",
        page_name: "分享落地页",
        entrance: extranceName[CFG.channel],
      });
    }
    // setTimeout(() => {
    //   this.shareRef.scrollTo(0, 70)
    // }, 50)
  }

  componentWillUnmount() {
    MatterViewDuration("b12112", +new Date() - this.startTime,{
      page_name: "分享落地页",
    });
  }

  getShareInfo = async () => {
    const { success, data } = await API.coop_getLoadingInfo();
    if (success && data) {
      this.setState({
        shareInfo: data,
      });
    }
    // if (!data?.validUid) {
    //   modalStore.pushPop("Loginpop")
    // }
  };

  /** 跳转微信端活动 */
  toWeActHandle = () => {
    let indexUrl = CFG.indexUrl
    const worksNum = getUrlParam("worksNum")
    MatterViewDuration("b12112", +new Date() - this.startTime);
    if (getUrlParam("inviteCode")) {
      // handleLogClick(38);
      // MatterShareOpt( "b12112", "d12113", {
      //   button_name: "立即为他助力按钮",
      //   page_name: "分享落地页",
      //   entrance: extranceName[CFG.channel],
      //   // operation_name: "立即为他助力按钮",
      // });
      sensorLog(LOG_KEY.click, "b12112", "d12113", {
        button_name: "为TA助力按钮",
        page_name: "分享落地页",
        entrance: extranceName[CFG.channel],
      });
      handleLogClick(49)
    } else if(worksNum){
      indexUrl = CFG.workPage
      sensorLog(LOG_KEY.click, "b12112", "d12116", {
        button_name: "立即参与",
        page_name: "为TA点赞按钮",
        entrance: extranceName[CFG.channel],
      });
      // handleLogClick(35);
      // MatterShareOpt("b12112", "d12116", {
      //   button_name: "为TA点赞按钮",
      //   page_name: "分享落地页",
      //   entrance: extranceName[CFG.channel],
      // });
      handleLogClick(52)
    } else {
      // MatterShareOpt("b12112", "d12116", {
      //   button_name: "立即参与按钮",
      //   page_name: "分享落地页",
      //   entrance: extranceName[CFG.channel],
      // });
      sensorLog(LOG_KEY.click, "b12112", "d12114", {
        button_name: "立即参与按钮",
        page_name: "分享落地页",
        entrance: extranceName[CFG.channel],
      });
      handleLogClick(50)
    }


    CFG.workerCode = getUrlParam("ykCode");
    if(isMiniprogram()){ //小程序域名写死
      CFG.domain = "https://96094.activity-24.m.duiba.com.cn";
    }else{
      CFG.domain = location.origin
    }
    let url =
      CFG.domain +
      indexUrl +
      "&channel=" +
      CFG.channel +
      `${!!getUrlParam("inviteCode") ? "&inviteCode=" + getUrlParam("inviteCode") : ""}` +
      `${!!CFG.workerCode ? `&ykCode=${CFG.workerCode}` : ""}` +
      `${!!worksNum ? `&worksNum=${worksNum}` : ""}` +
      `&agentCode=${CFG.agentCode || ""}&actPlatforms=${CFG.actPlatforms || ""}&actId=${CFG.actId || ""}`;
      // alert(url)
    location.href = url;
  };

  judgeBtn = () => {
    const inviteCode = getUrlParam("inviteCode")

    const worksNum = getUrlParam("worksNum")

    if(inviteCode) {
      return <span className="assist_btn md49"></span>
    } else if(worksNum) {
      return <span className="zan_btn md52"></span>
    } else {
      return <span className="normal_btn md50"></span>
    }
  }

  componentWillUnmount() {
    MatterViewDuration("b12112", +new Date() - this.startTime);
  }


  render() {
    // const { actStartTimestamp, actEndTimestamp } = this.state?.shareInfo || {};
    let inviteCode = getUrlParam("inviteCode")

    const worksNum = getUrlParam("worksNum")
    return (
      <div className="sharepage_wrap" ref={(r) => (this.shareRef = r)}>
        <div className="sharepage modal_center">
          <span className={worksNum ? "zanBg" : "bg"}></span>
          {!!inviteCode && <span className="invite_text"></span>}
          {/* <span className="title"></span> */}
          {/* <span className="time">
            活动时间：{dateFormatter(actStartTimestamp, "yyyy年MM月dd日")}-{dateFormatter(actEndTimestamp, "MM月dd日")}
          </span> */}
          {this.judgeBtn()}
          {/* {getUrlParam("inviteCode") ? <span className="assist_btn"></span> : <span className="normal_btn"></span>} */}
          <span className="click_area" onClick={() => this.toWeActHandle()}></span>
        </div>
      </div>
    );
  }
}
export default Sharepage;
