'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './opuspage.less';
import { _asyncThrottle, dateFormatter } from '@src/utils/utils';
import store from '@src/store';
import modalStore from '@src/store/modal';
import { Button } from '@src/components/Button';
import { PAGE_MAP } from '@src/utils/constants';
import { LOG_KEY, pageView, sensorLog } from '@src/utils/sensors';

@observer
class Opuspage extends React.Component {
  constructor(props) {
    super(props);
  }
  componentDidMount() {
    this.flushIndex()
    pageView("b12108", {
      page_name: "作品详情页",
    });
    sensorLog(LOG_KEY.exposure, "b12108", "d12109", {
      page_name: "作品详情页",
      button_name: "返回按钮",
    });
    sensorLog(LOG_KEY.exposure, "b12108", "d12110", {
      page_name: "作品详情页",
      button_name: "评论按钮",
    });
    sensorLog(LOG_KEY.exposure, "b12108", "d12111", {
      page_name: "作品详情页",
      button_name: "点赞按钮",
    });
  }

  flushIndex = async () => {
    await store.getOpusInfo()
  }

  doComment = () => {
    sensorLog(LOG_KEY.click, "b12108", "d12110", {
      page_name: "作品详情页",
      button_name: "评论按钮",
    });
    modalStore.pushPop("Commentpop")
  }
  doThumbsUp = _asyncThrottle(() => {
    if (!store.endOpus) {
      return
    }
    sensorLog(LOG_KEY.click, "b12108", "d12111", {
      page_name: "作品详情页",
      button_name: "点赞按钮",
    });
    if (store.opusInfo?.remainThumbsTimes > 0) {
      store.doThumbsUp()
    } else {
      modalStore.pushPop("Nopointpop")
    }
  })
  handleOnScroll = _asyncThrottle(async () => {
    let dom = document.getElementById("commentlist")
    const contentScrollTop = dom.scrollTop; //滚动条距离顶部
    const clientHeight = dom.clientHeight; //可视区域
    const scrollHeight = dom.scrollHeight;//滚动区域总高度
    if (contentScrollTop + clientHeight >= scrollHeight - 10) {
      if (store.nowPage >= store.totalPage) {
        return
      }
      await store.getCommentInfo(store.nowPage + 1)
    }
    // console.log(contentScrollTop, clientHeight, scrollHeight)
  })
  backHandle = () => {
    sensorLog(LOG_KEY.click, "b12108", "d12109", {
      page_name: "作品详情页",
      button_name: "返回按钮",
    });
    store.changePage(PAGE_MAP.HOME_PAGE)
  }
  render() {
    return (
      <div className="opuspage">
        <span className="bg2"></span>
        <span className="bg"></span>
        <div className='infoList'>
          <div className='list' id="commentlist"
            onScrollCapture={() => this.handleOnScroll()} >
            {
              store.commentInfo?.map((item, index) => {
                return (
                  <div className="commentbox" key={"com" + index}>
                    <div className='comInfoBox'>
                      <span className="commentinfo">{item.content}</span>
                      <span className="time">{dateFormatter(item.time, "yyyy/MM/dd hh:mm:ss")}</span>
                    </div>
                    <span className="uid">{item.nickname}</span>
                    <span className="avatar">
                      <img src={item.avatar}></img>
                    </span>
                  </div>
                )
              })
            }

          </div>
          {
            store.opusInfo?.salesmanFlag ? <Button className="big_pinglun md32" onClick={this.doComment}></Button> :
              <div>
                <Button className="dianzan md33" onClick={this.doThumbsUp}></Button>
                <Button className="pinglun md32" onClick={this.doComment}></Button>
              </div>
          }
          {/*  */}
          <div className="infobox">
            <span className="infotitle">{store.opusInfo?.worksInfo?.worksTitle}</span>
            <span className="infolab">
              {store.opusInfo?.worksInfo?.worksDesc}
            </span>
            <span className="line"></span>
            <span className="infobg">
              <img src={store.opusInfo?.worksInfo?.worksImg}></img>
            </span>
          </div>
        </div>
        <Button className="back md31" onClick={this.backHandle}></Button>

        {/* <span className="zan"></span> */}


      </div>
    );
  }
}
export default Opuspage;
