'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './likelogpage.less';
import API from '@src/api';
import { Button } from '@src/components/Button';
import store from '@src/store';
import { _asyncThrottle, dateFormatter } from '@src/utils/utils';
import { PAGE_MAP } from '@src/utils/constants';

@observer
class Likelogpage extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      logList: [],        // 列表数据
      isSearching: false, // 是否在请求列表中
    }
    this.pageNum = 1;
    this.pageSize = 20;
    this.isLoadedAll = false;
  }

  async componentDidMount() {
    await this.getLogList()
  }

  /** 
   * 获取列表数据
   */
  getLogList = async () => {
    if (this.state.isSearching) return;
    if (this.isLoadedAll) return;
    this.setState({ isSearching: true })
    const params = {
      pageNum: this.pageNum, // 第几页，从1开始
      pageSize: this.pageSize, // 每页大小
    }
    const { success, data } = await API[
      store.setIndex?.agent ? 'beThumbsRecords' : 'myThumbsRecords'
    ](params);
    if (success) {
      const _list = this.state.logList.concat(data?.list || [])
      this.setState({
        isSearching: false,
        logList: _list,
      });
      this.isLoadedAll = data?.totalPage <= this.pageNum;
      this.pageNum++;
    }
  }

  /**
   * 监听页面滚动
   */
  handScroll = (e) => {
    if (
      e.target.scrollTop + e.target.clientHeight + 10 >=
      e.target.scrollHeight
    ) {
      this.getLogList();
    }
  };

  // 返回
  backHandle = _asyncThrottle(() => {
    store.changePage(PAGE_MAP.HOME_PAGE)
    // if (store.setIndex?.agent) {
    //   store.changePage(PAGE_MAP.SALE_PAGE)
    // } else {
    //   store.changePage(PAGE_MAP.USER_HOME_PAGE)
    // }
  })

  render() {
    const { logList } = this.state;
    const { agent } = store.setIndex || {};
    return (
      <div className={`likelogpage modal_center ${agent ? 'md20' : 'md45'}`}>
        <span className="bg"></span>
        <span className="list_bg"></span>
        <div className="detail_list" onScroll={this.handScroll}>
          {logList?.map((item, index) => (
            <div className="detail_item" key={index}>
              <div className="left_info">
                <span className="item_title">{item.changeDesc}</span>
                <span className="item_time">{dateFormatter(item.time, "yyyy.MM.dd hh:mm")}</span>
              </div>
              <span className="item_num">{item.changeType == 1 ? '+' : '-'}{item.changeNum}</span>
              <span className="item_line"></span>
            </div>
          ))}
        </div>
        <span className="title"></span>
        <Button className="back" onClick={this.backHandle}></Button>
      </div>
    );
  }
}
export default Likelogpage;
