'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './drawpage.less';
import API from '@src/api';
import { _asyncThrottle, _throttle } from '@src/utils/utils';
import modalStore from '@src/store/modal';
import store from '@src/store';
import { CHANNEL_PARAMS, PAGE_MAP } from '@src/utils/constants';
import { CircleTurntable } from '@spark/circle-turntable'
import { Button } from '@src/components/Button';
import { Marquee, Toast } from '@spark/ui';
import { isWeChat } from '@src/utils/share';
import { LOG_KEY, pageView, sensorLog } from '@src/utils/sensors';

@observer
class Drawpage extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      drawInfo: {}
    }
    this.btnStarting = false  // 转盘是否启动
    this.turntableRef = null  // 大转盘
    this.drawResultInfo = {}
  }

  componentDidMount() {
    this.getDrawInfo()
    pageView("b12117", {
      page_name: "抽奖大转盘",
    });
    sensorLog(LOG_KEY.exposure, "b12117", "d12118", {
      page_name: "抽奖大转盘",
      button_name: "立即抽奖按钮",
    });
  }

  /** 获取转盘信息 */
  getDrawInfo = async () => {
    const { success, data } = await API.drawIndex()
    if (success && data) {
      this.setState({
        drawInfo: data || {}
      })
    }
  }

  // 开始抽奖
  lottteryHandle = _asyncThrottle(async () => {
    sensorLog(LOG_KEY.click, "b12117", "d12118", {
      page_name: "抽奖大转盘",
      button_name: "立即抽奖按钮",
    });
    // 微信端拦截
    if (isWeChat()) {
      // 友客小程序
      if (CFG.channel == CHANNEL_PARAMS.YK_MINI) {
        return Toast("请前往人保寿险管家app活动抽奖～")
      }
      // 其他微信端 提醒唤端弹窗
      else {
        return modalStore.pushPop("CodePop")
      }
    }

    const { prizeVOs, remainDrawTimes } = this.state.drawInfo
    // 无抽奖次数
    if (!remainDrawTimes) {
      return modalStore.pushPop("Drawchancepop")
    }

    if (this.btnStarting) return false
    const { success, data } = await API.drawJoin()
    if (success && data) {
      this.btnStarting = true
      // 转盘转动开始抽奖
      this.turntableRef.launch()
      this.drawResultInfo = data || {}

      // 转盘停止转动，指针停在index
      const index = prizeVOs?.findIndex(item => item.prizeId === this.drawResultInfo.prizeId)
      console.info('index', index)
      this.turntableRef.braking(index);
    } else {
      this.btnStarting = false
      this.getDrawInfo()
    }
  })

  // 转盘停止处理
  stopOkHandle = () => {
    this.btnStarting = false

    if (!this.drawResultInfo?.prizeId) {
      modalStore.pushPop("NoPrizeCard", { data:this.drawResultInfo })
    } else {
      modalStore.pushPop("PrizePop", { data:this.drawResultInfo })
    }
    this.getDrawInfo()
  }

  /** 返回 */
  backHome = _throttle(() => {
    if (this.btnStarting) return false
    store.changePage(PAGE_MAP.HOME_PAGE)
  })

  /** 奖品 */
  prizeHandle = _throttle(async () => {
    if (this.btnStarting) return false
    if (!store.setIndex?.agreeFlag) {
      modalStore.pushPop("Yinsirulepop", { from: PAGE_MAP.DRAW_PAGE });
      return;
    }
    store.changePage(PAGE_MAP.PRIZE_PAGE, { from: PAGE_MAP.DRAW_PAGE })
  })

  /** 规则 */
  ruleHandle = _throttle(async () => {
    if (this.btnStarting) return false
    modalStore.pushPop("RulePop")
  })

  render() {
    const { prizeVOs, remainDrawTimes, carouselVos } = this.state.drawInfo
    return (
      <div className="drawpage modal_center md35">
        <span className="bg"></span>
        <span className="logo"></span>
        <span className="title"></span>
        <Button className="back_btn" onClick={this.backHome} />
        <Button className="rule_btn" onClick={this.ruleHandle}></Button>
        <Button className="prize_btn" onClick={this.prizeHandle}></Button>
        {/* 奖品轮播 */}
        <div className="prize_info">
          <div className="prize_info_bg"></div>
          <div className="prize_info_laba"></div>
          <div className="prize_info_list">
            <Marquee
              baseData={carouselVos || []}
              time={2000}
              direction="top"
              renderItem={(item) => (
                <div className="prize_info_item">用户 {item.escapePhone} 获得了{item.prizeName}</div>
              )}
            ></Marquee>
          </div>
        </div>
        <Button className="draw_btn_box md36" onClick={this.lottteryHandle}>
          <span className="draw_btn"></span>
          <span className="left_num">剩余次数：{remainDrawTimes || 0}</span>
        </Button>
        <div className="turantable">
          <CircleTurntable
            className="turantable_box"
            ref={ref => this.turntableRef = ref}
            options={prizeVOs || []}
            angleOffset={20}  // 角度偏移量
            radian={100}  // 奖项半径
            launchDuration={1000}  // 启动时间
            // 大转盘背景
            renderBackground={<div className="turantable_bg"></div>}
            // 大转盘指针
            renderStartButton={<></>}
            // 渲染奖品信息
            renderOption={(option) => {
              return <div className="prize_item">
                {/* 因为按照8格子 正常偏移量得是23 但中第三奖品停不下来 就只能调成20 然后样式调一下往右靠 */}
                {option.prizeName?.length > 6
                  ? <div className="prize_name long">{option.prizeName.slice(0, 6)}...</div>
                  : <div className="prize_name">{option.prizeName}</div>
                }
                <img className="prize_img" src={option.prizeImg} alt="" />
              </div>
            }}
            didStop={this.stopOkHandle}
          />
          <span className="pointer"></span>
        </div>
        <span className="cover"></span>
      </div>
    );
  }
}
export default Drawpage;
