import React from "react";
import {observer} from "mobx-react";
import "./SaleManPage.less";
import {Button} from "@src/components/Button";
import musicStore from "@src/store/musicStore";
import {Swiper} from "antd-mobile";
import modalStore from "@src/store/modal";
import store from "@src/store";
import {_asyncThrottle, _throttle, dateFormatter, windowJumpUrl, getUrlParam} from "@src/utils/utils";
import {CHANNEL_PARAMS, PAGE_MAP} from "@src/utils/constants";
import {RES_PATH} from "../../../sparkrc";
import {SvgaPlayer} from "@spark/svgaplayer";
import share from "@src/store/share";
import {LOG_KEY, MatterShareOpt, MatterViewDuration, MatterViewOpt, pageView, sensorLog} from "@src/utils/sensors";

@observer
class SaleManPage extends React.Component {

  startTime = +new Date();
  componentDidMount = async () => {
    // modalStore.pushPop("CodePop");
    await store.getProductSearch();


    if (CFG.channel == CHANNEL_PARAMS.YK_MINI) {
      MatterViewOpt("b12091", {
        page_name: "业务员端首页-友客小程序",
      });

      sensorLog(LOG_KEY.exposure, "b12091", "d12093", {
        page_name: "业务员端首页-友客小程序",
        button_name: "去拜访按钮",
      });

      sensorLog(LOG_KEY.exposure, "b12091", "d12092", {
        page_name: "业务员端首页-友客小程序",
        button_name: "分享按钮",
      });

    } else {
      MatterViewOpt("b12084", {
        page_name: "业务员端-活动首页",
      });
    }
    sensorLog(LOG_KEY.exposure, "b12084", "d12090", {
      page_name: "业务员端-活动首页",
      button_name: "点赞明细按钮",
    });
    sensorLog(LOG_KEY.exposure, "b12084", "d12089", {
      page_name: "业务员端-活动首页",
      button_name: "邀好友点赞按钮",
    });

    sensorLog(LOG_KEY.exposure, "b12084", "d12087", {
      page_name: "业务员端-活动首页",
      button_name: "上传照片按钮",
    });
    sensorLog(LOG_KEY.exposure, "b12084", "d12086", {
      page_name: "业务员端-活动首页",
      button_name: "奖品按钮",
    });
    sensorLog(LOG_KEY.exposure, "b12084", "d12085", {
      page_name: "业务员端-活动首页",
      button_name: "规则按钮",
    });
  };

  componentWillUnmount() {
    // alert(getUrlParam("ykCode"))
    if (CFG.channel == CHANNEL_PARAMS.YK_MINI) {
      MatterViewDuration("b12091", +new Date() - this.startTime, {
        page_name: "业务员端首页-友客小程序",
        sales_id: getUrlParam("ykCode") || CFG.spcCode || store.setIndex?.agentCode,
      });
    } else {
      MatterViewDuration("b12084", +new Date() - this.startTime, {
        page_name: "业务员端-活动首页",
        sales_id: getUrlParam("ykCode") || CFG.spcCode || store.setIndex?.agentCode,
      });
    }
  }

  /** 规则按钮*/
  clickRule = _asyncThrottle(() => {
    sensorLog(LOG_KEY.click, "b12084", "d12085", {
      page_name: "业务员端-活动首页",
      button_name: "规则按钮",
    });
    if (!store.checkActTime("rule")) return;
    modalStore.pushPop("RulePop");
  });
  /** 奖品按钮*/
  clickPrize = _asyncThrottle(() => {
    sensorLog(LOG_KEY.click, "b12084", "d12086", {
      page_name: "业务员端-活动首页",
      button_name: "奖品按钮",
    });
    if (!store.checkActTime("prize")) return;
    if (!store.setIndex?.agreeFlag) {
      modalStore.pushPop("Yinsirulepop");
      return;
    }
    store.changePage(PAGE_MAP.PRIZE_PAGE);
  });
  /** 分享按钮-友客小程序且业务员身份*/
  clickShare = _asyncThrottle(() => {
    sensorLog(LOG_KEY.click, "b12091", "d12092", {
      page_name: "业务员端首页-友客小程序",
      button_name: "分享按钮",
    });
    if (!store.checkActTime()) return;
    share.doShare();
  });
  /** 暂停音乐按钮*/
  toStop = _asyncThrottle(() => {
    if (!store.checkActTime()) return;
    musicStore.changeMusicStatus();
  });
  /** 播放音乐按钮*/
  toPlay = _asyncThrottle(() => {
    if (!store.checkActTime()) return;
    musicStore.changeMusicStatus();
  });
  /** 去拜访按钮-友客小程序banner渠道首页且业务员身份*/
  clickVisit = _asyncThrottle(() => {
    MatterShareOpt("b12091", "d12093", {
      page_name: "业务员端首页-友客小程序",
      button_name: "去拜访按钮",
    });
    if (!store.checkActTime()) return;
    if (!CFG.channel == CHANNEL_PARAMS.YK_MINI) return;
    // windowJumpUrl(store.frontVariable?.SaleManUrl);
    windowJumpUrl(store.frontVariable?.SaleManUrl
      + "&actPlatforms=" + getUrlParam("actPlatforms")
      + "&agentCode=" + getUrlParam("agentCode")
      + "&actId=" + getUrlParam("actId")
      + "&channel=" + CFG.channel);
  });
  /** 去投稿按钮*/
  clickToUpload = _asyncThrottle(() => {
    sensorLog(LOG_KEY.click, "b12084", "d12087", {
      page_name: "业务员端-活动首页",
      button_name: "上传照片按钮",
    });
    if (!store.checkActTime()) return;
    modalStore.pushPop("UploadPop");
  });
  /** 邀好友点赞按钮*/
  clickToShow = _asyncThrottle((num) => {
    MatterShareOpt( "b12084", "d12089", {
      page_name: "业务员端-活动首页",
      button_name: "邀好友点赞按钮",
    });
    if (!store.checkActTime()) return;
    share.doInviteZan(num);
  });
  /** 点赞明细按钮按钮*/
  clickToZan = _asyncThrottle(() => {
    sensorLog(LOG_KEY.click, "b12084", "d12090", {
      page_name: "业务员端-活动首页",
      button_name: "点赞明细按钮",
    });
    if (!store.checkActTime()) return;
    store.changePage(PAGE_MAP.LIKE_LOG_PAGE);
  });

  showOpus = _asyncThrottle((data) => {
    if (!store.checkActTime()) return;
    store.workDetailNum = data;
    store.changePage(PAGE_MAP.OPUS_PAGE);
  });

  render() {
    const {setIndex} = store;
    return (setIndex?.agent ? <div className="SaleManPage">
      <div className="bg"/>
      <div className="logo"/>
      <SvgaPlayer className="pic" src={RES_PATH + "SVG/3输出首页氛围.svga"}/>
      <div className="title">
        <div className="txt">
          活动时间:{dateFormatter(store.setIndex?.actStartTime, "yyyy年MM月dd号")}-{dateFormatter(store.setIndex?.actEndTime, "MM月dd号")}
        </div>
      </div>
      <div className="useridbox">
        <span className="useridbg"></span>
        <span className="userid">用户ID：{setIndex?.uid}</span>
      </div>
      {
        CFG.channel == CHANNEL_PARAMS.YK_MINI && <Button className="shareBtn md11" onClick={this.clickShare}/>
      }
      {
        musicStore?.status
          ? <Button className="music_open md9" onClick={this.toStop}/>
          : <Button className="music_close md9" onClick={this.toPlay}/>
      }
      <Button className="prize md7" onClick={this.clickPrize}/>
      <Button className="rule md8" onClick={this.clickRule}/>
      {
        CFG.channel == CHANNEL_PARAMS.YK_MINI &&
        <SvgaPlayer className="visit md10" src={RES_PATH + "SVG/2输出去拜访icon.svga"} onClick={this.clickVisit}/>
      }
      <div className="IP"/>
      <div className="iptxt">
        <div className="txt1">
          截止{dateFormatter(store.setProductSearch?.openTime, "MM月dd号")}，照片点赞数排行前{store.setProductSearch?.maxAwardRank}名可得专属好礼
        </div>
      </div>
      {
        store.setProductSearch?.rankPrizeInfo?.length > 3 && <Swiper
          className="PrizeList"
          indicator={() => ""}
          direction="horizontal"
          trackOffset={0}
          slideSize={35}
          stuckAtBoundary={false}
          loop={true}
          autoplay={true}
          autoplayInterval={3000}
          allowTouchMove={true}

        >
          {
            store.setProductSearch?.rankPrizeInfo?.map((item, index) => {
              return <Swiper.Item className="PeizeList_item" key={index} style={{marginLeft: 145}}>
                <div className="PeizeList_item_bg">
                  <img className="PeizeList_item_img" src={item.prizeImg}/>
                  <div className="PeizeList_item_name">
                    {item.prizeName}
                  </div>
                </div>
              </Swiper.Item>;
            })
          }
        </Swiper>
      }

      {
        store.setProductSearch?.rankPrizeInfo?.length <= 3 && <Swiper
          className="PrizeList"
          indicator={() => ""}
          direction="horizontal"
          trackOffset={2}
          slideSize={33.33}
          stuckAtBoundary={false}
          loop={true}
          autoplay={false}
          autoplayInterval={3000}
          allowTouchMove={false}
        >
          {
            store.setProductSearch?.rankPrizeInfo?.map((item, index) => {
              return <Swiper.Item className="PeizeList_item" key={index}>
                <div className="PeizeList_item_bg">
                  <img className="PeizeList_item_img" src={item.prizeImg}/>
                  <div className="PeizeList_item_name">
                    {item.prizeName}
                  </div>
                </div>
              </Swiper.Item>;
            })
          }
        </Swiper>
      }


      {
        store.setProductSearch?.rankInfos?.length > 0 ? (<div className="pictureList">
            {
              store.setProductSearch?.rankInfos?.map((item, index) => {
                return <div className="pictureList_item" key={index} onClick={() => {
                  this.showOpus(item.worksNum);
                }}>
                  <img className="pictureList_item_img" src={item.worksImg}/>

                  {/* 排名 */}
                  <div className="pictureList_item_numBg">
                    <div className="pictureList_item_num">
                      第{item.rank}名
                    </div>
                  </div>

                  {/* 编号 */}
                  <div className="pictureList_item_bianhaoBg">
                    <div className="pictureList_item_bianhao">
                      作品编号：{item.worksNum}
                    </div>
                  </div>

                  {/* 标题 */}
                  <div className="pictureList_item_txt">
                     <span className="pictureList_item_name">
                      {item.worksTitle}
                    </span>

                    <div className="pictureList_item_btn"/>
                    <span className="pictureList_item_line">
                    {item.thumbsNum}
                    </span>
                  </div>

                  {/* 性别 */}
                  <img className="pictureList_item_sexImg"
                       src={+item.sex === 1 && RES_PATH + "SaleManPage/man.png" || +item.sex === 2 && RES_PATH + "SaleManPage/woman.png"}/>
                </div>;
              })
            }
          </div>)
          : (<div className="nothing"/>)
      }

      {/* 状态0-未投稿   状态3-已投稿已失败*/}
      {
        (store.setProductSearch?.worksInfo?.status === 0
          || store.setProductSearch?.worksInfo?.status === 3
          || store.setProductSearch?.worksInfo === null
        ) && <div className="uploadBg">
          <Button className="uploadBtn md13" onClick={this.clickToUpload}/>
          <div className="uploadTxt">
            请于{dateFormatter(store.setProductSearch?.openTime, "MM月dd号")}前上传您的照片
          </div>
        </div>
      }

      {/* 状态1-已投稿未审核 */}
      {
        store.setProductSearch?.worksInfo?.status === 1 && <div className="myPhoto">
          <img className="myPhoto_Pic" src={store.setProductSearch?.worksInfo?.worksImg}/>
          <div className="myPhoto_title">
            --
          </div>
          <div className="kuang">
          <span className="myPhoto_txt">
            作品编号：--
          </span>
            <div className="wait"/>
          </div>
        </div>
      }

      {/* 状态2-已投稿已通过 */}
      {
        store.setProductSearch?.worksInfo?.status === 2 && <div className="myRank">
          <img className="myRank_Pic" src={store.setProductSearch?.worksInfo?.worksImg}/>
          <div className="myRank_title">
            {/* todo */}
            我的排名:{store.setProductSearch?.worksInfo?.rankIndex == -1 ? "500+" : store.setProductSearch?.worksInfo?.rankIndex}
          </div>
          <div className="myRank_name">
            {store.setProductSearch?.worksInfo?.worksTitle}
          </div>
          <div className="kuang2">
            <span className="myRank_txt">
              作品编号:{store.setProductSearch?.worksInfo?.worksNum}
            </span>
            <div className="pass"/>
          </div>
          <Button className="myRank_btn md14"
                  onClick={() => this.clickToShow(store.setProductSearch?.worksInfo?.worksNum)}/>
        </div>
      }
      <SvgaPlayer className="smallTitle" src={RES_PATH + "SVG/1输出闪亮瞬间标题.svga"}/>
      <Button className="rank md12" onClick={this.clickToZan}/>
    </div> : "");
  }
}

export default SaleManPage;
