import React from "react";
import {observer} from "mobx-react";
import "./HomeDemo.less";
import store from "@src/store";
import {PAGE_MAP} from "@src/utils/constants";
import {isWeChat} from "@src/utils/share";
import modalStore from "@src/store/modal";
import shareStore from "@src/store/share";

@observer
class HomeDemo extends React.Component {
  async componentDidMount() {

    if (isWeChat()) {
      if (!await store.checkBindStatus()) return;
    }

    await shareStore.doAssist();
    await store.getSalesManIndex();
    if (store.setIndex?.agent) {
      store.changePage(PAGE_MAP.SALE_PAGE);
    } else {
      store.changePage(PAGE_MAP.USER_HOME_PAGE);
    }

    /** 绑定手机号判断 */
    if (isWeChat()) {
      if (!store.setIndex.validUid) {
        modalStore.pushPop("LoginPop");
      }
    }
  }

  render() {
    return <div className="homeDemo">
      <div className="bg"></div>
    </div>;
  }
}

export default HomeDemo;
