'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './pointsucpop.less';
import modalStore from '@src/store/modal';
import store from '@src/store';
import { PAGE_MAP } from '@src/utils/constants';

@observer
class Pointsucpop extends React.Component {
  constructor(props) {
    super(props);
  }
  closePop() {
    modalStore.closePop("Pointsucpop")
  }
  goDraw() {
    modalStore.closePop("Pointsucpop")
    store.changePage(PAGE_MAP.DRAW_PAGE)
  }
  render() {
    return (
      <div className="pointsucpop modal_center">
        <span className="light"></span>
        <span className="bg"></span>
        <div className="prizebox">
          <span className="lab">成功获得抽奖机会+{this.props.popData}</span>
          <span className="box"></span>
        </div>
        <span className="btn md34" onClick={this.goDraw}></span>
        <span className="close" onClick={this.closePop}></span>
      </div>
    );
  }
}
export default Pointsucpop;
