import React from "react";
import {observer} from "mobx-react";
import "./UploadPop.less";
import {Button} from "@src/components/Button";
import modalStore from "@src/store/modal";
import {_asyncThrottle} from "@src/utils/utils";
import API from "@src/api";
import {Toast} from "@spark/ui";
import store from "@src/store";
import {LOG_KEY, pageView, sensorLog} from "@src/utils/sensors";

@observer
class UploadPop extends React.Component {
  state = {
    confirm: false, // 是否勾选协议
    photoImg: "", // 图片
    title: "", // 标题
    content: "", // 内容
  };
componentDidMount() {
  pageView("b12101", {
    page_name: "业务员端-上传作品页",
  });
  sensorLog(LOG_KEY.exposure, "b12101", "d12103", {
    page_name: "业务员端-上传作品页",
    button_name: "返回按钮",
  });
  sensorLog(LOG_KEY.exposure, "b12101", "d12102", {
    page_name: "业务员端-上传作品页",
    button_name: "确认上传按钮",
  });

}
  /** 关闭按钮*/
  clickToBack = () => {
    modalStore.closePop("UploadPop");
    sensorLog(LOG_KEY.click, "b12101", "d12103", {
      page_name: "业务员端-上传作品页",
      button_name: "返回按钮",
    });
  };
  /** 隐私协议打勾按钮*/
  clickToConfirm = async () => {
      this.setState({
        confirm: true
      });
  };

  /** 选择图片按钮*/
  selectImg = _asyncThrottle(async (e) => {
    const imgFile = e.target.files[0];
    if (imgFile) {
      const isLt1M = imgFile.size / 10240 / 10240 < 30;
      if (!isLt1M) {
        Toast("上传图片大小不能超过30Mb!");
        return;
      }
      const reader = new FileReader();
      reader.readAsDataURL(imgFile);
      reader.onload = async () => {
        const {success, data} = await API.uploadImg({
          img64: reader.result,
        });
        if (success) {
          this.setState({photoImg: data});
        }
      };
    }
  });

  /** 标题输入框*/
  onTitleInput = (e) => {
    let value = e.target.value;
    this.setState({
      title: value,
    });
  };
  /** 内容输入框*/
  onContentInput = (e) => {
    let value = e.target.value;
    this.setState({
      content: value,
    });
  };
  /** 隐私协议弹窗按钮*/
  clickToPrivacy = _asyncThrottle( async () => {
    await store.getProductSearch();
    modalStore.pushPop("PrivacyPop", {agreeText: store.setProductSearch?.worksAgreementText}, true);
  });
  /** 确认提交按钮*/
  clickSubmit = _asyncThrottle(async () => {

    sensorLog(LOG_KEY.click, "b12101", "d12102", {
      page_name: "业务员端-上传作品页",
      button_name: "确认上传按钮",
    });

    const {photoImg, title, content, confirm,} = this.state;
    console.log(photoImg, 123, title, 123, content, 123, confirm, 123);
      modalStore.pushPop("ConfirmPop", {photoImg, title, content, confirm}, true);
  });

  /** 置灰确认提交按钮*/
  clickGarySubmit = _asyncThrottle(() => {
    sensorLog(LOG_KEY.click, "b12101", "d12102", {
      page_name: "业务员端-上传作品页",
      button_name: "确认上传按钮",
    });
    const {photoImg, title, content, confirm,} = this.state;
    if (!photoImg) {
      return Toast("请先上传照片～");
    } else if (!title) {
      return Toast("请先输入作品标题～");
    } else if (!content) {
      return Toast("请先输入作品介绍～");
    } else if (!confirm) {
      return Toast("请勾选同意授权～");
    }
  });

  cancel = () => {
    this.setState({
      photoImg: "",
    });
  };

  render() {
    const {confirm, title, content, photoImg} = this.state;
    const isFill = title && content && photoImg && confirm;
    return <div className="UploadPop">
      <div className="bg"/>
      <Button className="back md15" onClick={this.clickToBack}/>
      <div className="white"/>

      <input className="title"
             value={title}
             maxLength="10"
             placeholder="请输入作品标题，10个字以内"
             onChange={this.onTitleInput}
      />
      <div className="line"/>
      <textarea className="content"
                value={content}
                maxLength="200"
                placeholder="请输入作品介绍，建议在100字以内（上传作品字数控制200字)"
                onChange={this.onContentInput}
      />
      {
        photoImg ?
          <>
            <img className="upload_img" src={photoImg}/>
            <Button className="cancel" onClick={this.cancel}/>
          </>

          :
          <>
            <Button className="upload_btn">
              <input type="file" accept="image/*" onChange={this.selectImg}></input>
            </Button>
          </>
      }


      <div className="describe">
        格式要求jpg、png大小不超过30kb 尺寸1024x768px
      </div>
      {
        confirm ? <Button className="confirm_btn"/>
          : <Button className="circle_btn" onClick={this.clickToConfirm}/>
      }

      <span className="txt">
        我已阅读并同意
        <Button className="privacy" onClick={this.clickToPrivacy}>
        《用户协议》
      </Button>
      </span>
      {
        isFill ? <Button className="btn md16" onClick={this.clickSubmit}/>
          : <Button className="gary_btn" onClick={this.clickGarySubmit}/>
      }
    </div>;
  }
}

export default UploadPop;
