import React from "react";
import {observer} from "mobx-react";
import "./ReviewFailedPop.less";
import {Button} from "@src/components/Button";
import modalStore from "@src/store/modal";

@observer
class ReviewFailedPop extends React.Component {

  /** 关闭按钮*/
  clickClose = () => {
    modalStore.closePop();
  }

  render() {
    return <div className="ReviewFailedPop modal_center">
      <div className="light"/>
      <div className="bg">
        <div className="rankText">
          您上传的照片不符合上传规范， <br/>请认真阅读上传规则后重新上传～
        </div>
      </div>
      <Button className="reSubmit md19" onClick={this.clickClose}/>
      <Button className="close" onClick={this.clickClose}/>
    </div>;
  }
}

export default ReviewFailedPop;
