import React from "react";
import {observer} from "mobx-react";
import "./RankNoPrizePop.less";
import {Button} from "@src/components/Button";
import modalStore from "@src/store/modal";
import store from "@src/store";

@observer
class RankNoPrizePop extends React.Component {

  clickClose = () => {
    modalStore.closePop();
  }

  render() {
    const {data} = this.props.popData;
    return <div className="RankNoPrizePop modal_center">
      <div className="light"/>
      <div className="bg">
        <div className="rankText">
          最终排名为{+data.rank == -1 ? "500+" : data.rank}
        </div>
      </div>
      <Button className="know md41" onClick={this.clickClose}/>
      <Button className="close" onClick={this.clickClose}/>
    </div>;
  }
}

export default RankNoPrizePop;
