import React from "react";
import {observer} from "mobx-react";
import "./PrivacyPop.less";
import {Button} from "@src/components/Button";
import modalStore from "@src/store/modal";

@observer
class PrivacyPop extends React.Component {

  clickClose = () => {
    modalStore.closePop("PrivacyPop");
  };

  render() {
    const {agreeText} = this.props.popData;
    return <div className="PrivacyPop modal_center">
      <div className="light"/>
      <div className="bg">
        <div className="rankText" dangerouslySetInnerHTML={{__html:agreeText}}/>
      </div>
      <Button className="close md44" onClick={this.clickClose}/>
    </div>;
  }
}

export default PrivacyPop;
