import React from "react";
import {observer} from "mobx-react";
import "./ConfirmPop.less";
import {Button} from "@src/components/Button";
import modalStore from "@src/store/modal";
import {Toast} from "@spark/ui";
import API from "@src/api";
import store from "@src/store";
import {PAGE_MAP} from "@src/utils/constants";
import {_asyncThrottle} from "@src/utils/utils";

@observer
class ConfirmPop extends React.Component {


  clickCancel = () => {
    modalStore.closePop("ConfirmPop");
  };

  clickConfirm = _asyncThrottle( async () => {
    const {title, photoImg, content, confirm} = this.props.popData;
    const {success} = await API.saveOrUpdateWork({
      worksImg: photoImg,
      worksTitle: title,
      worksDesc: content,
      lockAgree: confirm,
    });
    if (!success) return;
    modalStore.closePopAll();
    store.changePage(PAGE_MAP.HOME_PAGE);
    Toast("上传成功，请耐心等待审核～");
  });

  render() {
    const {title, photoImg} = this.props.popData;
    console.log(title, photoImg);
    return <div className="ConfirmPop modal_center">
      <div className="light"/>
      <div className="bg">
        <div className="title">
          活动期间仅可上传1张照片哦
        </div>
        <img className="picture" src={photoImg}/>
        <div className="txt">
          {title}
        </div>
      </div>
      <Button className="confirm md18" onClick={this.clickConfirm}/>
      <Button className="cancel md17" onClick={this.clickCancel}/>
    </div>;
  }
}

export default ConfirmPop;
