import { generateAPI } from "./utils.js";

const API = generateAPI({
  /** 获取活动规则 */
  getRule: "projectRule.query",
  /** 获取前端配置项 */
  getFrontVariable: "coop_frontVariable.query",
  /** 参与接口 post请求 */
  doJoin: {
    uri: "join.do",
    method: "post"
  },
  /** 签到 */
  doSign: {
    uri: "checkin_1/doSign.do",
    withToken: true,  // 携带token
  },

  // cookie丢失-临时保存cookie
  tempSaveCookie: {
    uri: "/autoLogin/tempSaveCookie",
    showMsg: false,
  },
  // cookie丢失-重新设置cookie
  resetCookie: "/autoLogin/resetCookie",
  userLogin: {
    uri: "userLogin.check",
    showMsg: false,
  },
  buriedPoint: {
    uri: "home/buriedPoint.do",
    showMsg: false,
  },

  /** 获取任务列表 */
  getTaskInfo: {
    uri: "task_1/queryTasks.do",
  },
  /** 完成任务 */
  doCompleted: {
    uri: "task_1/doCompleted.do",
    method: "post",
    withToken: true,
  },
  /** 领取奖励 */
  sendPrize: {
    uri: "task_1/sendPrize.do",
    method: "post",
    withToken: true,
  },
  /** 绑定友客业务员信息接口 */
  bindYk: {
    uri: "agent/bindYk.do",
    method: "post",
    showMsg: false,
  },
  /** 生成唤端二维码 */
  getLongLinkQrcode: `/customActivity/qrcode/getQrcode`,

  // /** 获取邀请码 */
  // getInviteCode: {
  //   uri: "customInvite1/getInviteCode.do",
  //   method: "post",
  //   withToken: true,
  // },
  // /** 助力 */
  // doAssist: {
  //   uri: "customInvite1/doAssist.do",
  //   method: "post",
  //   withToken: true,
  //   showMsg: false,
  // },
  /** 落地页 */
  coop_getLoadingInfo: "customInvite1/outside.do",
  /** 获取地区 */
  getParentCode: "/gaw/address/getChildrenByParentCode",
  /** 抽奖首页 */
  drawIndex: "draw/index.do",
  /** 抽奖 */
  drawJoin: {
    uri: "draw/doDraw.do",
    withToken: true,
  },
  /** 被点赞记录 */
  beThumbsRecords: "works/beThumbsRecords.do",
  /** 我的点赞记录 */
  myThumbsRecords: "works/myThumbsRecords.do",

  /** 校验验证码并登录 */
  coopCheckCode: {
    uri: "examine/coop_checkCode.do",
    method: "post",
  },

  getCode: {
    uri: "/customActivity/piccLife/sendSmsCode",
    // showMsg: false,
  },

  /** 发送验证码 */
  coopSendCode: {
    uri: "examine/coop_sendCode.do",
    method: "post",
  },
  /** 校验是否绑定手机号 */
  checkBind: "/customActivity/piccLife/check",
  /** 奖品页 */
  prize: "/crecord/getrecordmn",

  /** 助力 */
  doAssist: {
    uri: "inviteAssist_1/doAssist.do",
    method: "post",
    withToken: true,
    // showMsg: false,
  },
  /** 获取邀请码 */
  getInviteCode: {
    uri: "inviteAssist_1/getInviteCode.do",
    method: "post",
    withToken: true,
  },

  /** 保存/修改作品信息*/
  saveOrUpdateWork: {
    uri: "works/saveOrUpdateWork.do",
    method: "post",
    contentType: "json",
    headers: {
      "Content-Type": "application/json",
    },
  },

  /** 上传图片 */
  uploadImg: {
    uri: "/customActivity/duiba/imgUploadUrl",
    method: "post",
    contentType: "json",
  },

  /** 业务员首页*/
  salesManIndex: {
    uri: "works/index.do",
    showMsg: false,
  },

  /** 审核玩法-审核首页*/
  examineIndex: {
    uri: "examine/examineIndex.do",
    method: "post",
  },

  /** 同意隐私协议接口*/
  lockAgree: {
    uri: "works/lockAgree.do",
  },

  /** 投稿玩法-作品排行榜*/
  productSearch: {
    uri: "works/productSearch.do",
  },
  // 投稿玩法-作品详情
  workDetail: 'works/workDetail.do',
  // 投稿玩法-作品评论记录
  commentRecords: 'works/commentRecords.do',
  // 投稿玩法-作品评论
  comment: {
    uri: "works/comment.do",
    method: "post",
    contentType:"json",
  },
  // 投稿玩法-作品点赞
  thumbsUp: {
    uri: 'works/thumbsUp.do',
    withToken: true,
  },

  /** 同意隐私协议接口 */
  agreePrivacy: {
    uri: "game/agreePrivacy.do",
    withToken: true,
    method: "post",
  },

  // 推送使用
  outside: `inviteAssist_1/outside.do`,


  bindPhone: {
    uri: "/customActivity/piccLife/bindWithCode",
    method: "post",
    showMsg: false,
  },

  /** 业务员抽奖接口 */
  salesManDraw: {
    uri: "works/draw.do",
    withToken: true,
  }

});

// console.log('======', API)

export default API;
