import React, { useState } from "react";
import { observer } from "mobx-react";
import "./FillAddress.less";
import store from "@src/store";
import { emojiReg, REG_TEL, specialStrReg } from "@src/utils/constants";
// import modalStore from "@src/store/modal";
// import { Button } from "@src/components/Button";
import { Toast } from "@spark/ui";
import API from "@src/api";
import { callApi } from "@spark/api-base";
// import { LOG_KEY, pageView, sensorLog } from "@src/utils/sensors";
import taskStore from "@src/store/task";
import { _asyncThrottle } from "../../utils/utils";
import modalStore from "../../store/modal";
import { Button } from "../Button";
import { handleLogClick, handleLogExposure } from "../../../MD";
// wzjTODO 换皮
@observer
class FillAddress extends React.Component {
  fillMd=false
  state = {
    name: "",
    mobile: "",
    area: "",
    province: "",
    city: "",
    street: "",
    detail: "",
    addrCode: "",
  }

  componentDidMount() {
    handleLogExposure(32)
    // this.initSensor();
  }

  initSensor(){

    pageView("b7391", {
      page_name: "地址填写页",
    });

    sensorLog(LOG_KEY.exposure, "b7391", "d7393", {
      page_name: "地址填写页",
      button_name: "提交信息按钮",
    });
  }

  ClickClose = () => {
    modalStore.closePop("FillAddress")
  }

  onNameInput = (e) => {
    let value = e.target.value
    // value = value.replace(emojiReg, '');
    // value = value.replace(specialStrReg, '');
    this.setState({
      name: value,
    });
  };

  onMobileInput = (e) => {
    this.setState({
      mobile: e.target.value.replace(/[^\d]/g, ''),
    });
  };

  onDetailInput = (e) => {
    let value = e.target.value;
    // value = value.replace(emojiReg, '');
    // value = value.replace(specialStrReg, '');
    this.setState({
      detail: value,
    });
  };

  clickArea = () => {
    modalStore.pushPop("Selectmodal", {
      doSelect: this.doSelect,
    },true);
  }

  doSelect = ({province, city, area, street, addrCode,}) => {
    this.setState({
      province,
      city,
      area,
      street,
      addrCode,
    });
  }

  clickSubmit = _asyncThrottle(async () => {
     handleLogClick(32)
    // sensorLog(LOG_KEY.click, "b7391", "d7393", {
    //   page_name: "地址填写页",
    //   button_name: "提交信息按钮",
    // });

    const {
      name, mobile,
      area, province, city, street, addrCode,
      detail
    } = this.state;

    if (!REG_TEL.test(mobile)) {
      return Toast('请输入正确的手机号～');
    }
    const { projectId, saveAddresUrl, getPrize, recordId, agentCode, prizeProjectId} = this.props?.popData;
    let res = await callApi(saveAddresUrl, {
      province,
      city,
      area,
      detail,
      name,
      mobile,
      recordId,
      agentCode,
      street,
      projectId:prizeProjectId,
      addrCode,
      from: CFG.channel || "2",
      actPlatforms: CFG.actPlatforms,
      actId: CFG.actId,
    });
    getPrize(projectId);
    modalStore.closePop("FillAddress");


    // const {success, data} = await API.saveOrUpdateAddress({
    //   name, mobile,
    //   province, city, area, street,
    //   addrCode,
    //   detail,
    // });

    // if (!success) return;

    // store.changePage("ClaimList");
  });

  clickSubmitNoAct = () => {
    handleLogClick(32)
    Toast("请先填写完整信息", 1800, {hideOthers: true});
  }

  render() {

    const {name, mobile, area, province, city, street, detail} = this.state;

    const isFill = Boolean(name && mobile && area && province && city && detail);
    if(this.fillMd != isFill){
      console.log("曝光埋点")
      handleLogExposure(32);
      this.fillMd = isFill;
    }
    return <div className="FillAddress">
      <div className="bg" />
      <Button className="button-return" onClick={this.ClickClose} />

      <div className="infoList">
        <div className="inputG inputName">
          <div className="igLabel">收货人</div>
          <input
            className="igInput inputStyle"
            placeholder="收货人姓名"
            value={name}
            maxLength={10}
            onChange={this.onNameInput}
          />
        </div>

        <div className="inputG inputMobile">
          <div className="igLabel">手机号码</div>
          <input
            className="igInput inputStyle"
            placeholder="收货人手机号码"
            value={mobile}
            maxLength="11"
            onChange={this.onMobileInput}
          />
        </div>

        <div className="inputG inputArea">
          <div className="igLabel">所在地区</div>
          <div
            className={`igDiv ${province ? "" : "igInputGray"}`}
            placeholder="选择省/市/区"
            onClick={this.clickArea}
          >
            {province ? `${province}/${city}/${area}${!!street ? `/${street}` : ""}` : "选择省/市/区/街道"}
          </div>
          <div className="button-select" onClick={this.clickArea} />
        </div>

        <div className="inputG inputAddress">
          <div className="igLabel">详细地址</div>
          <input
            className="igInput inputStyle"
            placeholder="请填写详细地址"
            value={detail}
            onChange={this.onDetailInput}
            maxLength={100}
          />
        </div>
      </div>

      {
        isFill
          ? <Button className="submitAct" onClick={this.clickSubmit} />
          : <Button className="submitNoAct" onClick={this.clickSubmitNoAct} />
      }

    </div>;
  }
}

export default FillAddress;
