/**
 * 活动主入口
 */
import React, { Component } from "react";
import ReactDOM from "react-dom";
import { observer } from "mobx-react";
import "./app.less";
import store from "./store/index";
import Modal from "./modal/modal";
import "./utils/checkwebp"; // webp检查
import MD from "../MD"; // 埋点
MD();

// 此处为spark-cli动态生成
import LoadingDemo from "@src/pages/LoadingDemo/LoadingDemo";
import { PAGE_MAP } from "./utils/constants";
import Likelogpage from "./pages/likelogpage/likelogpage";
import Drawpage from "./pages/drawpage/drawpage";
import Sharepage from "./pages/sharepage/sharepage";
import AgentSharepage from "./pages/agentSharepage/sharepage";
import Prizepage from "./pages/prizepage/prizepage";
import Userhomepage from "./pages/userhomepage/userhomepage";
import { isWeChat, onInitShare, onUpdateShare } from "./utils/share";
import { getUrlParam, isMiniprogram } from "./utils/utils";
import { domain, ensureDomain } from "@spark/dbdomain";
import musicStore from "@src/store/musicStore";
import { RES_PATH } from "../sparkrc";

/**
 * 所有页面场景
 */
const pageMap = {
  [PAGE_MAP.LOADING_PAGE]: <LoadingDemo />,
  [PAGE_MAP.SHARE_PAGE]: <Sharepage />,
  [PAGE_MAP.AGENT_SHARE_PAGE]: <AgentSharepage />,
  [PAGE_MAP.LIKE_LOG_PAGE]: <Likelogpage />,
  [PAGE_MAP.DRAW_PAGE]: <Drawpage />,
  [PAGE_MAP.PRIZE_PAGE]: <Prizepage />,
  [PAGE_MAP.HOME_PAGE]: <Userhomepage />
};

@observer
class App extends Component {
  async componentDidMount() {

    musicStore.playSound(RES_PATH + "audio/bgm.mp3", true);

    // 获取前端开发配置，依据项目需要，酌情添加 ！！！
    await store.getFrontVariable();

    await onInitShare();
    // 获取动态域名
    await ensureDomain();
    CFG.domain = domain;
    if (isMiniprogram()) {
      //小程序域名写死
      CFG.domain = "https://96094.activity-24.m.duiba.com.cn";
    }

    console.info("分享默认渠道===", CFG.workerCode);
    if (store.curPage != PAGE_MAP.SHARE_PAGE) {
      // 首页
      // 初始化分享
      let shareUrl = `${CFG.domain}${CFG.shareUrl}`;
      shareUrl += `&ykCode=${CFG.workerCode || CFG.agentCode || ""}`;
      shareUrl += `&channel=${CFG.defaultChannel}&agentCode=${CFG.agentCode || ""}&actPlatforms=${CFG.actPlatforms || ""}&actId=${CFG.actId || ""}`;
      onUpdateShare({
        ...JSON.parse(store.frontVariable.shareInfo),
        url: `${CFG.domain}${CFG.indexLogin}${encodeURIComponent(shareUrl)}`
      });
    } else if (store.curPage == PAGE_MAP.SHARE_PAGE) {
      let shareUrl = `${CFG.domain}${CFG.shareUrl}${getUrlParam("inviteCode") ? "&inviteCode=" + getUrlParam("inviteCode") : ""}${getUrlParam("worksNum") ? "&worksNum=" + getUrlParam("worksNum") : ""}`;
      shareUrl += `&ykCode=${CFG.workerCode || CFG.agentCode || ""}`;
      if (CFG.channel) {
        shareUrl += `&channel=${CFG.defaultChannel}&agentCode=${CFG.agentCode || ""}&actPlatforms=${CFG.actPlatforms || ""}&actId=${CFG.actId || ""}`;
      }
      let _shareInfo = JSON.parse(store.frontVariable.shareInfo);
      if (getUrlParam("worksNum")) {
        _shareInfo = JSON.parse(store.frontVariable.shareInfoZan);
      } else if (getUrlParam("inviteCode")) {
        _shareInfo = JSON.parse(store.frontVariable.shareInfoInvite);
      }
      onUpdateShare({
        ..._shareInfo,
        url: `${CFG.domain}${CFG.indexLogin}${encodeURIComponent(shareUrl)}`
      });
    }

  }

  render() {
    const { curPage, pageData } = store;
    return (
      <>
        {{ ...pageMap[curPage], props: { ...pageData } }}
        <Modal />
      </>
    );
  }
}

ReactDOM.render(<App />, document.getElementById("root"));
