import React from "react";
import {observer} from "mobx-react";
import "./CodePop.less";
import {Button} from "@src/components/Button";
import modalStore from "@src/store/modal";
import QRCode from "qrcode";
import store from "@src/store";
import {LOG_KEY, pageView, sensorLog} from "@src/utils/sensors";

@observer
class CodePop extends React.Component {

  state = {
    codeImg: ""
  };

  componentDidMount = async () => {
    await this.creatCode();
    pageView("b12854", {
      page_name: "扫码唤端页",
    });
    sensorLog(LOG_KEY.exposure, "b12854", "d12855", {
      page_name: "扫码唤端页",
      button_name: "关闭按钮",
    });
  };

  /** 生成二维码*/
  creatCode = async () => {
    await store.getFrontVariable();
    const url = await QRCode.toDataURL(store.frontVariable?.Url,{
      errorCorrectionLevel: 'L', // 纠错级别，可选值：'L'、'M'、'Q'、'H'
      margin: 1, // 边距，单位：像素
    });
    this.setState({
      codeImg: url
    });
  };

  /** 关闭 */
  clickClose = () => {
    modalStore.closePop();
    sensorLog(LOG_KEY.click, "b12854", "d12855", {
      page_name: "扫码唤端页",
      button_name: "关闭按钮",
    });
  };

  render() {
    const {codeImg} = this.state;
    return <div className="CodePop modal_center md4">
      <div className="light"/>
      <div className="bg">
        <img className="code" src={codeImg}/>
      </div>
      <Button className="close" onClick={this.clickClose}/>
    </div>;
  }
}

export default CodePop;
