import React from "react";
import {observer} from "mobx-react";
import "./RankNoPrizePop.less";
import {Button} from "@src/components/Button";
import modalStore from "@src/store/modal";

@observer
class RankNoPrizePop extends React.Component {

  clickClose = () => {
    modalStore.closePop();
  }

  render() {
    const {data} = this.props.popData;
    return <div className="RankNoPrizePop modal_center">
      <div className="bg"/>
      <div className="rankText">
        最终排名为{(data.rank && data.rank > -1) ? data.rank : "3000+"}
      </div>
      <Button className="know md26" onClick={this.clickClose}/>
      <Button className="close" onClick={this.clickClose}/>
    </div>;
  }
}

export default RankNoPrizePop;
