import React from "react";
import { observer } from "mobx-react";
import "./selectmodal.less";
import { Swiper, SwiperSlide } from "swiper/react";
// import 'style-loader!css-loader!swiper/swiper-bundle.css';
import "../../../src/swiper-bundle.css";
import API from "../../api";
import { _throttle } from "../../utils/utils";
import modalStore from "../../store/modal";
import { Button } from "../Button";
// 地址选择器 什么都别改直接复制
@observer
class Selectmodal extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      provinceList: [],
      cityList: [],
      areaList: [],
      streetList: [],
      provinceCode: 0,
      cityCode: 0,
      areaCode: 0,
      streetCode: 0,
    };
  }

  swiperRef;
  swiperRef2;
  swiperRef3;

  // getParentCode
  async componentDidMount() {
    //获取省
    await this.getCodeList(null, "provinceList");
    //获取市
    const { provinceList, provinceCode } = this.state;
    await this.getCodeList(provinceList[provinceCode]?.adCode, "cityList");
    //获取区
    const { cityList, cityCode } = this.state;
    await this.getCodeList(cityList[cityCode]?.adCode, "areaList");

    //获取街道
    const { areaList, areaCode } = this.state;
    await this.getCodeList(areaList[areaCode]?.adCode, "streetList");
  }

  /**获取省市区接口 */
  async getCodeList(parentCode, type) {
    const params = {};
    if (parentCode) {
      params.parentCode = parentCode;
    }
    const { success, data } = await API.getParentCode(params);
    if (success) {
      this.setState({
        [type]: data,
      });
    }
  }

  /**
   * 省选择
   * @param {*} swiper
   */
  onProvinceSwiper = (swiper) => {
    if (swiper) {
      swiper.on("slideChange", (swiper) => {
        console.error("Slide changed!", swiper.activeIndex);

        this.setState(
          {
            provinceCode: swiper.activeIndex,
          },
          async () => {
            //获取市
            const { provinceList } = this.state;
            await this.getCodeList(provinceList[swiper.activeIndex]?.adCode, "cityList");
            //获取区
            const { cityList, cityCode } = this.state;
            await this.getCodeList(cityList[cityCode]?.adCode, "areaList");
            //获取街道
            const { areaList, areaCode } = this.state;
            await this.getCodeList(areaList[areaCode]?.adCode, "streetList");
          }
        );
        this.swiperRef?.slideTo(0);
        this.swiperRef2?.slideTo(0);
        this.swiperRef3?.slideTo(0);
      });
    }
  };
  /**
   * 市选择
   */
  onCitySwiper = (swiper) => {
    console.error("Slide changed!", swiper.activeIndex);

    this.setState(
      {
        cityCode: swiper.activeIndex,
      },
      async () => {
        //获取区
        const { cityList } = this.state;
        await this.getCodeList(cityList[swiper.activeIndex]?.adCode, "areaList");
        //获取街道
        const { areaList, areaCode } = this.state;
        await this.getCodeList(areaList[areaCode]?.adCode, "streetList");
      }
    );
    this.swiperRef2?.slideTo(0);
    this.swiperRef3?.slideTo(0);
  };
  /**
   * 区选择
   * @param {*} swiper
   */
  onAreaSwiper = (swiper) => {
    console.error("Slide changed!", swiper.activeIndex);
    this.setState(
      {
        areaCode: swiper.activeIndex,
      },
      async () => {
        //获取街道
        const { areaList, areaCode } = this.state;
        await this.getCodeList(areaList[areaCode]?.adCode, "streetList");
      }
    );
    this.swiperRef3?.slideTo(0);
  };

  /**
   * 街道选择
   * @param {*} swiper
   */
  onStreetSwiper = (swiper) => {
    console.error("Slide changed!", swiper.activeIndex);
    this.setState({
      streetCode: swiper.activeIndex,
    });
  };

  /**
   * 确认选择
   */
  doSelect = _throttle(() => {
    const { provinceList, cityList, areaList, streetList, provinceCode, cityCode, areaCode, streetCode } = this.state;
    const province = provinceList[provinceCode]?.name;
    const city = cityList[cityCode]?.name;
    const area = areaList[areaCode]?.name;
    const street = streetList[streetCode]?.name;
    const addrCode = streetList[streetCode]?.adCode || areaList[areaCode]?.adCode;
    console.log(province + "" + city + "" + area + "" + street);
    //确定展示到页面
    const { doSelect } = this.props.popData;
    doSelect && doSelect({ province, city, area, street, addrCode });
    modalStore.closePop("Selectmodal");
  });

  /** 取消 */
  doCancel = () => {
    modalStore.closePop("Selectmodal");
  };

  onClose() {
    modalStore.closePop("Selectmodal");
  }

  render() {
    const { provinceList, cityList, areaList, streetList } = this.state;
    return (
      <div className="selectmodal">
        <span className="bg" />
        <Button className="cancelbtn" onClick={this.doCancel}>
          取消
        </Button>
        <Button className="confirmbtn" onClick={this.doSelect}>
          确认
        </Button>
        <div className="dateCont">
          <div className="dates">
            <Swiper
              slidesPerView={5}
              initialSlide={0}
              centeredSlides={true}
              direction="vertical"
              className="_date"
              onSwiper={this.onProvinceSwiper}>
              {provinceList?.map((item, index) => (
                <SwiperSlide className="dateItem" key={index}>
                  <div>{item?.name}</div>
                </SwiperSlide>
              ))}
            </Swiper>
          </div>
          <div className="hours">
            <Swiper
              slidesPerView={5}
              initialSlide={0}
              centeredSlides={true}
              direction="vertical"
              className="_date"
              onSwiper={(swiper) => (this.swiperRef = swiper)}
              onSlideChange={(swiper) => this.onCitySwiper(swiper)}>
              {cityList?.map((item, index) => (
                <SwiperSlide className="dateItem" key={index}>
                  <div>{item?.name}</div>
                </SwiperSlide>
              ))}
            </Swiper>
          </div>
          <div className="minutes">
            <Swiper
              slidesPerView={5}
              initialSlide={0}
              centeredSlides={true}
              direction="vertical"
              className="_date"
              onSwiper={(swiper) => (this.swiperRef2 = swiper)}
              onSlideChange={(swiper) => this.onAreaSwiper(swiper)}>
              {areaList?.map((item, index) => (
                <SwiperSlide className="dateItem" key={index}>
                  <div>{item?.name}</div>
                </SwiperSlide>
              ))}
            </Swiper>
          </div>
          <div className="street">
            <Swiper
              slidesPerView={5}
              initialSlide={0}
              centeredSlides={true}
              direction="vertical"
              className="_date"
              onSwiper={(swiper) => (this.swiperRef3 = swiper)}
              onSlideChange={(swiper) => this.onStreetSwiper(swiper)}>
              {streetList?.map((item, index) => (
                <SwiperSlide className="dateItem" key={index}>
                  <div>{item?.name}</div>
                </SwiperSlide>
              ))}
            </Swiper>
          </div>
        </div>
      </div>
    );
  }
}

export default Selectmodal;
