'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './likelogpage.less';
import API from '@src/api';
import { Button } from '@src/components/Button';
import store from '@src/store';
import { _asyncThrottle, dateFormatter } from '@src/utils/utils';
import { PAGE_MAP } from '@src/utils/constants';

@observer
class Likelogpage extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      logList: [],        // 列表数据
      isSearching: false, // 是否在请求列表中
    }
    this.pageNum = 1;
    this.pageSize = 20;
    this.isLoadedAll = false;
  }

  async componentDidMount() {
    await this.getLogList()
  }

  /** 
   * 获取列表数据
   */
  getLogList = async () => {
    if (this.state.isSearching) return;
    if (this.isLoadedAll) return;
    this.setState({ isSearching: true })
    const params = {
      distinctAssistUserId: 1, // 是否去重助力用户，默认值：0 1=是
      queryIntervalType: 4, // 1=当日、4=永久
      pageNum: this.pageNum, // 第几页，从1开始
      pageSize: this.pageSize, // 每页大小
    }
    const { success, data } = await API.queryInviteRecords(params);
    if (success) {
      const _list = this.state.logList.concat(data?.list || [])
      this.setState({
        isSearching: false,
        logList: _list,
      });
      this.isLoadedAll = data?.totalPage <= this.pageNum;
      this.pageNum++;
    }
  }

  /**
   * 监听页面滚动
   */
  handScroll = (e) => {
    if (
      e.target.scrollTop + e.target.clientHeight + 10 >=
      e.target.scrollHeight
    ) {
      this.getLogList();
    }
  };

  // 返回
  backHandle = _asyncThrottle(() => {
    store.changePage(PAGE_MAP.HOME_PAGE)
  })

  render() {
    const { logList } = this.state;
    return (
      <div className="likelogpage modal_center">
        <span className="bg"></span>
        <span className="list_bg"></span>
        <div className="list_title">
          <div className="title_item1">序号</div>
          <div className="title_item2">邀请用户</div>
          <div className="title_item3">邀请时间</div>
        </div>
        <div className="detail_list" onScroll={this.handScroll}>
          {logList?.map((item, index) => (
            <div className="detail_item" key={index}>
              <span className="item_num">{index + 1}</span>
              <span className="item_title">{item.assistUserId}</span>
              <span className="item_time">{dateFormatter(item.gmtCreate, "yyyy.MM.dd")}</span>
            </div>
          ))}
        </div>
        <span className="title"></span>
        <Button className="back" onClick={this.backHandle}></Button>
      </div>
    );
  }
}
export default Likelogpage;
