import React from "react";
import { observer } from "mobx-react";
import "./AssistFailPanel.less";
import { Button } from "@src/components/Button";
import modalStore from "@src/store/modal";
import store from "@src/store";
import { PAGE_MAP } from "@src/utils/constants";

@observer
class AssistFailPanel extends React.Component {

  componentDidMount = async () => {
    const { message, code } = this.props.popData;

    const md = {
      200306: 18,
      200304: 17,
      200302: 16,
      20002: 15
    }[+code] || message;

    this.setState({
      md: md
    });

  };

  /** 关闭 */
  clickClose = () => {
    modalStore.closePop();
  };

  clickOk = () => {
    modalStore.closePop();
    store.changePage(PAGE_MAP.HOME_PAGE);
  }

  render() {

    const { message, code } = this.props.popData;

    const msg = {
      200306: "无法为自己助力",
      200304: "好友今日被助力次数达到上限",
      200302: "只有新用户才可助力",
      20002: "活动已结束"
    }[+code] || message;

    const md = {
      200306: "md18",
      200304: "md17",
      200302: "md16",
      20002: "md15"
    }[+code];

    return <div className="AssistFailPanel modal_center">
      <div className="bg"/>
      <div className="tip">{msg}</div>
      <Button className={`btn ${md}`} onClick={this.clickOk} />
      <Button className="close" onClick={this.clickClose} />
    </div>;
  }
}

export default AssistFailPanel;
