import React, { Component } from "react";
import Pop_winprize from "../components/pop_winprize/pop_winprize";
import "./modal.less";
import { observer } from "mobx-react";
import modalStore from "../store/modal";
import { toJS } from "mobx";
import RankPrizePop from "@src/components/RankPrizePop/RankPrizePop";
import RankNoPrizePop from "@src/components/RankNoPrizePop/RankNoPrizePop";
import NoPrizeCard from "@src/components/NoPrizeCard/NoPrizeCard";
import CodePop from "@src/components/CodePop/CodePop";
import LoginPop from "@src/components/LoginPop/LoginPop";
import Taskpop from "@src/components/taskpop/taskpop";
import RulePop from "@src/components/RulePop/RulePop";
import FillAddress from "../components/FillAddress/FillAddress";
import Selectmodal from "../components/selectmodal/selectmodal";
import Yinsirulepop from "../components/yinsirulepop/yinsirulepop";
import LongImgPop from "@src/components/longImgPop/longImgPop";
import AssistCountPanel from "@src/components/AssistCountPanel/AssistCountPanel";
import CarvePanel from "@src/components/CarvePanel/CarvePanel";
import AssistSucPanel from "@src/components/AssistSucPanel/AssistSucPanel";
import AssistFailPanel from "@src/components/AssistFailPanel/AssistFailPanel";
/**
 * 弹窗配置
*/

export const cfg = {
  // 任务弹窗
  Taskpop,
  // 排行榜中奖弹窗
  RankPrizePop,
  // 排行榜未中奖弹窗
  RankNoPrizePop,
  // 中奖弹窗
  Pop_winprize: Pop_winprize,
  // 未中奖弹窗(卡片切换)
  NoPrizeCard,
  // 二维码弹窗
  CodePop,
  // 登录弹窗
  LoginPop,
  // 规则弹窗
  RulePop,
  // 选择地址弹窗
  FillAddress: FillAddress,
  // 地址选择器
  Selectmodal: Selectmodal,
  // 隐私协议
  Yinsirulepop,
  // 增援海报视频弹窗
  LongImgPop,

  AssistCountPanel,
  CarvePanel,
  AssistSucPanel,
  AssistFailPanel,

};

@observer
class Modal extends Component {
  constructor(props) {
    super(props);
  }

  componentDidMount() {}

  render() {
    const list = toJS(modalStore.popList);

    if (!list.length) {
      // TODO:此处根据需要自行修改
      // document.body.style.overflow='auto';
      return <section></section>;
    }

    let PopUpMulti, popUpMultiData;

    if (list.length > 1 && list[list.length - 1].isMulti == true) {
      const popObj2 = list[list.length - 1];
      PopUpMulti = cfg[popObj2.key];
      popUpMultiData = popObj2.data;
    }

    const popObj = list[0];
    const PopUp = cfg[popObj.key];
    const popData = popObj.data;

    if (PopUp || PopUpMulti) {
      document.body.style.overflow = 'hidden';
    }

    return <section className="modal-hoc-bg" style={{
      zIndex: modalStore.popList.length ? 1000 : -1,
      display: modalStore.popList.length ? 'block' : 'none'
    }}>
      {PopUp && <PopUp popData={popData} />}
      {PopUpMulti && <section className="modal-hoc-bg" style={{
        zIndex: modalStore.popList.length ? 1000 : -1,
        display: modalStore.popList.length ? 'block' : 'none'
      }}><PopUpMulti popData={popUpMultiData} />
      </section>}
    </section>;
  }

}

export default Modal;
