import React from "react";
import { observer } from "mobx-react";
import "./MusicBtn.less";
import classNames from "classnames";

import { RES_PATH } from "../../../sparkrc";
import musicStore from "@src/store/musicStore";
import { Button } from "@src/components/Button";

@observer
class MusicBtn extends React.Component {

  componentDidMount() {
  }

  componentWillUnmount() {
  }

  /**
   * 音效加载/播放
   */
  toggleHandle = (e) => {
    const { onClick } = this.props;
    musicStore.mute = !musicStore.mute;
    onClick?.(e);
  };

  render() {
    const {
      children,
      className,
      style = {},
      enable = RES_PATH + "common/musicOpen.png",
      disable = RES_PATH + "common/musicClose.png"
    } = this.props;

    const { mute } = musicStore;

    const cls = classNames(`com-music-btn`, className);

    return <Button
      className={cls}
      style={{
        ...style
      }}
      onClick={this.toggleHandle}>
      {
        mute
          ? <img src={disable} />
          : <img src={enable} />
      }
      {children}
    </Button>;
  }
}

export default MusicBtn;
