import React from "react";
import {observer} from "mobx-react";
import "./RulePop.less";
import {Button} from "@src/components/Button";
import modalStore from "@src/store/modal";
import store from "@src/store";

@observer
class RulePop extends React.Component {


  componentDidMount() {
    store.initRule();
  }

  clickClose = () => {
    modalStore.closePop();
  };

  render() {
    return <div className="RulePop modal_center">
      <div className="light"/>
      <div className="bg">
       <div className="rankText" dangerouslySetInnerHTML={{__html: store.ruleInfo}}/>
      </div>
      <Button className="close" onClick={this.clickClose}/>
    </div>;
  }
}

export default RulePop;
