'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './sharepage.less';
import { _throttle, dateFormatter, getUrlParam, windowJumpUrl } from '@src/utils/utils';
import { accessLog } from 'duiba-utils';
import store from '@src/store';
import API from '@src/api';
import { extranceName, PAGE_MAP } from '@src/utils/constants';
import modalStore from '@src/store/modal';
import { handleLogClick, handleLogExposure } from '../../../MD';
import shareStore from '@src/store/share';
import { LOG_KEY, MatterShareOpt, MatterViewOpt, sensorLog } from '@src/utils/sensors';
// wxjTODO 换皮 客经页面
@observer
class AgentSharepage extends React.Component {
  constructor(props) {
    super(props);

    this.state = {
      shareInfo: {}
    }

    this.shareRef = null;
  }

  async componentDidMount() {

    MatterViewOpt("b12112", {
      page_name: "分享落地页",
    });

    sensorLog(LOG_KEY.exposure, "b12112", "d12115", {
      button_name: "分享活动按钮",
      page_name: "分享落地页",
      entrance: extranceName[CFG.channel],
    });

  }

  getShareInfo = async () => {
    const { success, data } = await API.coop_getLoadingInfo();
    if (success && data) {
      this.setState({
        shareInfo: data
      })
    }
  }

  /** 跳转微信端活动 */
  toWeActHandle = () => {

    CFG.workerCode = getUrlParam("ykCode");
    let url = CFG.domain + CFG.indexUrl + '&channel=' + CFG.channel + `${!!getUrlParam("inviteCode") ? ("&inviteCode=" + getUrlParam("inviteCode")) : ""}` + `${!!CFG.workerCode ? `&ykCode=${CFG.workerCode}` : ""}`
    location.href = url
  }

  handleShareAct = _throttle(() => {
    
    MatterShareOpt("b12112", "d12115", {
      button_name: "分享活动按钮",
      page_name: "分享落地页",
      entrance: extranceName[CFG.channel],
    });
    shareStore.doShare()
  })

  render() {
    // const { actStartTimestamp, actEndTimestamp } = this.state?.shareInfo || {};
    return (
      <div className="agentsharepage_wrap" ref={r => this.shareRef = r}>
        <div className="sharepage modal_center">
          <span className="bg"></span>
          {/* <span className="title"></span> */}
          <span className="normal_btn md51" onClick={this.handleShareAct}></span>
          {/* <span className="time">活动时间：{dateFormatter(actStartTimestamp, "yyyy年MM月dd日")}-{dateFormatter(actEndTimestamp, "MM月dd日")}</span> */}
          {/* {
            getUrlParam("inviteCode") ?
              <span className="assist_btn" ></span>
              :
              <span className="normal_btn"></span>
          } */}
          {/* <span className="click_area" onClick={() => this.toWeActHandle()}></span> */}
          {/* <span className="hand"></span> */}
          {/* <span className="logo"></span> */}
        </div>
      </div>
    );
  }
}
export default AgentSharepage;
