import React from "react";
import { observer } from "mobx-react";
import "./AssistSucPanel.less";
import { Button } from "@src/components/Button";
import modalStore from "@src/store/modal";
import { SvgaPlayer } from "@spark/svgaplayer";
import { RES_PATH } from "../../../sparkrc";
import store from "@src/store";
import { PAGE_MAP } from "@src/utils/constants";

@observer
class AssistSucPanel extends React.Component {

  componentDidMount = async () => {

  };

  /** 关闭 */
  clickClose = () => {
    modalStore.closePop();
  };

  clickOk = () => {
    modalStore.closePop();
    store.changePage(PAGE_MAP.DRAW_PAGE);
  }

  render() {
    return <div className="AssistSucPanel modal_center">
      <SvgaPlayer className="effect" src={RES_PATH + "svga/4输出弹窗氛围.svga"}/>
      <div className="bg"/>
      <Button className="btn md14" onClick={this.clickOk} />
      <Button className="close" onClick={this.clickClose} />
    </div>;
  }
}

export default AssistSucPanel;
