'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './taskpop.less';
import { unwatchPageVisibility, watchPageVisibility } from '@spark/utils';
import { handleLogClick, handleLogExposure } from '../../../MD';
import { SvgaPlayer } from '@spark/svgaplayer';
import { RES_PATH } from '../../../sparkrc';
import modalStore from '../../store/modal';
import { _throttle,_asyncThrottle, getUrlParam } from '../../utils/utils';
import { TASK_CODE,CHANNEL_PARAMS, PAGE_MAP } from '../../utils/constants';
import { setCookies } from '../../store/fetcher';
import taskStore from '../../store/task';
import store from '../../store';
import { LOG_KEY, MatterShareOpt, MatterViewOpt, pageView, sensorLog } from '../../utils/sensors';
import { Button } from '../Button';

@observer
class Taskpop extends React.Component {
  constructor(props) {
    super(props);
  }

  async componentDidMount() {

    window.infoCallBack = taskStore.getInfoCallback;
    window.browseCallBack = taskStore.getBrowseCallback;

    await taskStore.getTaskList();
    taskStore.taskList?.map((item, index) => {
      if(item?.taskStatus == 1) {
        sensorLog(LOG_KEY.exposure, "b12104", "d12106", {
          page_name: "赚点赞次数弹窗",
          button_name: "领取奖励按钮",
        });
      }
      if(item?.taskStatus == 0) {
        sensorLog(LOG_KEY.exposure, "b12104", "d12105", {
          page_name: "赚点赞次数弹窗",
          button_name: "去完成按钮",
        });
      }
    })
    watchPageVisibility(this.onPageVisibilityChange);

    this.initSensor();


  }

  initSensor() {

    pageView("b12104", {
      page_name: "赚点赞次数弹窗",
    });

    // sensorLog(LOG_KEY.exposure,"b7870","d8729");
    sensorLog(LOG_KEY.exposure, "b12104", "d12107", {
      page_name: "赚点赞次数弹窗",
      button_name: "返回按钮",
    });



  }

  componentWillUnmount() {
    unwatchPageVisibility(this.onPageVisibilityChange);
  }

  onPageVisibilityChange = async (visible) => {
    if (visible) {
      await setCookies();
      await taskStore.getTaskList();
    }
  };

  /** 去完成 */
  taskDoHandle = _asyncThrottle(async (item) => {
    const {taskStatus, code} = item || {};
    // if(code == TASK_CODE.INVITE){
    //   MatterShareOpt(LOG_KEY.click,"b7870","d8729")
    // }
    handleLogClick(23, 1);
    sensorLog(LOG_KEY.click, "b12104", "d12105", {
      page_name: "赚点赞次数弹窗",
      button_name: "去完成按钮",
    });
    await taskStore.doTask(item);

    taskStore.taskList?.map((item, index) => {
      if(item?.taskStatus == 1) {
        sensorLog(LOG_KEY.exposure, "b12104", "d12106", {
          page_name: "赚点赞次数弹窗",
          button_name: "领取奖励按钮",
        });
      }
    })
  })

  /** 领奖 */
  taskPrizeHandle = _asyncThrottle(async (item) => {
    const { code, taskStatus } = item || {};
    handleLogClick(23, 2);
    sensorLog(LOG_KEY.click, "b12104", "d12106", {
      page_name: "赚点赞次数弹窗",
      button_name: "领取奖励按钮",
    });

    await taskStore.getTaskPrize(item);
  })

  close = _asyncThrottle(async() => {
    // sensorLog(LOG_KEY.click, "b7394", "d7398", {
    //   page_name: "做任务赚骰子页",
    //   button_name: "关闭按钮",
    // });
    sensorLog(LOG_KEY.click, "b12104", "d12107", {
      page_name: "赚点赞次数弹窗",
      button_name: "返回按钮",
    });

    modalStore.closePop("Taskpop");
    // store.getHomeInfo()
    this.props.popData?.onClose && this.props.popData.onClose();

  })

  render() {
    const {taskList} = taskStore;
    return (
      <div className="taskpop topPop_move">
        <span className="bg"></span>
        <Button className="close md24" onClick={this.close}></Button>
        <div className="list">
          {
            taskList?.length > 0 &&
            taskList.map((val, key) => {
              val?.taskStatus == 0 && handleLogExposure(23, 1)
              val?.taskStatus == 1 && handleLogExposure(23, 2)
              return (
                <div className="item" key={key}>
                  <span className="bg_item"></span>
                  <div className="center_info">
                    <span className="title">{`${val?.title}(${val?.completedSize}/${val?.intervalLimitSize})`}</span>
                    {/* 「浏览企业人人保」、「浏览畅行保产品计划A赠险」、「浏览畅行保产品计划B赠险」 app端任务描述取描述 后端直接接口处理了 */}
                    <span className="subtitle textover">{val?.subTitle}</span>
                  </div>
                  <img src={val?.icon} className="icon" />
                  <div className="btns">
                    {/* 去完成 */}
                    {
                      val?.taskStatus == 0 &&
                      // (
                      //   CFG.channel != CHANNEL_PARAMS.RB_APP ||
                      //   (CFG.channel == CHANNEL_PARAMS.RB_APP && val?.code?.indexOf(TASK_CODE.BROWSE_SPECIAL_SHOW) < 0)
                      // ) &&
                      <Button className="complete_btn" onClick={() => this.taskDoHandle(val)}></Button>
                    }
                    {/* 待领取 */}
                    {val?.taskStatus == 1 &&
                      <Button className="receive_btn" onClick={() => this.taskPrizeHandle(val)}></Button>}
                    {/* 已完成 */}
                    {val?.taskStatus == 2 && <Button className="already_btn"></Button>}
                  </div>
                </div>
              )
            })
          }
        </div>
      </div>
    );
  }
}

export default Taskpop;
