'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './pop_winprize.less';
import { SvgaPlayer } from "@spark/svgaplayer";
import { RES_PATH } from "../../../sparkrc";
import { LOG_KEY, pageView, sensorLog } from "@src/utils/sensors";
import { Button } from '../Button';
import modalStore from '@src/store/modal';

@observer
class Pop_winprize extends React.Component {
  constructor(props) {
    super(props);
  }

  componentDidMount() {
    pageView("b12856", {
      page_name: "中奖弹窗",
    });
    sensorLog(LOG_KEY.exposure, "b12856", "d12858", {
      page_name: "中奖弹窗",
      button_name: "关闭按钮",
    });
    sensorLog(LOG_KEY.exposure, "b12856", "d12857", {
      page_name: "中奖弹窗",
      button_name: "开心收下按钮",
    });
  }

  clickClose = () => {
    modalStore.closePop();
    sensorLog(LOG_KEY.click, "b12856", "d12858", {
      page_name: "中奖弹窗",
      button_name: "关闭按钮",
    });
  };
  clickHappy = () => {
    modalStore.closePop();
    sensorLog(LOG_KEY.click, "b12856", "d12857", {
      page_name: "中奖弹窗",
      button_name: "开心收下按钮",
    });
  };


  render() {
    const { data } = this.props.popData;
    console.log(data, 123123);
    return (
      <div className="pop_winprize modal_center">
        <SvgaPlayer className="wp_light" src={RES_PATH + "svga/4输出弹窗氛围.svga"} />
        <Button className="wp_closebutton" onClick={this.clickClose} />
        <div className="wp_main">
          <span className="wp_background"></span>
          <span className="wp_tip">奖品可在首页 我的奖品 中查看</span>
          <Button className="wp_receivebutton md22" onClick={this.clickHappy} />
          <div className="wp_prizedisplay">
            <img className="prizeimg"
              src={data?.prizeImg}
              alt={data?.prizeName}
            />
            <span className="prizename">
              {data?.prizeName}
            </span>
          </div>
        </div>
      </div>
    );
  }
}
export default Pop_winprize;
