"use strict";

import React from "react";
import { observer } from "mobx-react";
import "./longImgPop.less";
import modalStore from "@src/store/modal";
import { _throttle } from "@src/utils/utils";
import { Button } from "../Button";
import DPlayer from "dplayer";
import musicStore from "@src/store/musicStore";
import { RES_PATH } from "../../../sparkrc";

@observer
class LongImgPop extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      isFinish: false,
      countdownTime: 15, // 单位s
    };
    this.timer = "";
    this.isStart = false;
    this.stop = false;
    this.dp = null;
  }

  componentDidMount() {
    if (this.props?.popData?.type == 2) {
      this.dp = new DPlayer({
        container: this.videoNode,
        video: {
          url: this.props?.popData?.imgUrl,
        },
        loop: true,
      });
      this.dp.on("play", () => {
        this.startInterval();
        musicStore.stopSound(RES_PATH + "audio/bgm.mp3");
      });
      this.dp.on("pause", () => {
        // this.endCountDown()
        musicStore.playSound(RES_PATH + "audio/bgm.mp3", true);
      });
    }
    if (this.props.popData?.noCount) {
      this.setState({
        isFinish: true,
      });
    } else {
      if(this.props?.popData?.type == 2) return
      this.startInterval();
    }
  }

  componentWillUnmount() {
    if (this.timer) clearInterval(this.timer);
  }

  /** 开始倒计时 */
  startInterval = () => {
    if (this.timer) clearInterval(this.timer);
    this.timer = setInterval(async () => {
      if (this.state.countdownTime === 0) {
        this.setState({
          isFinish: true,
        });
        clearInterval(this.timer);
        this.timer = "";
        // 完成任务
        const { taskSucCb } = this.props?.popData || {};
        taskSucCb && taskSucCb();
        return;
      }
      this.setState({
        countdownTime: Math.max(0, this.state.countdownTime - 1),
      });
    }, 1000);
  };

  /** 关闭当前页面 */
  closeHandle = () => {
    modalStore.closePop("LongImgPop");
    if (!this.props.popData.noCount) {
      modalStore.pushPop("Taskpop");
    }
  };

  render() {
    const { imgUrl, type } = this.props.popData || {};
    const { isFinish, countdownTime } = this.state;
    return (
      <div className="longImgPop">
        {type == 1 && <img src={imgUrl} alt="" className="mainImg" />}
        {type == 2 && (
          <div className="v-wrapper">
            <div ref={(node) => (this.videoNode = node)} id="my-player" className="video-js"></div>
          </div>
        )}

        <Button className="back_home" onClick={this.closeHandle}></Button>
        {!isFinish && <span className="countdown">{`${countdownTime}s`}</span>}
      </div>
    );
  }
}

export default LongImgPop;
