import React from "react";
import { observer } from "mobx-react";
import "./RankPrizePop.less";
import { Button } from "@src/components/Button";
import modalStore from "@src/store/modal";
import { SvgaPlayer } from "@spark/svgaplayer";
import { RES_PATH } from "../../../sparkrc";

@observer
class RankPrizePop extends React.Component {

  clickClose = () => {
    modalStore.closePop();
  };

  render() {
    const { data } = this.props.popData;
    return <div className="RankPrizePop modal_center">
      <SvgaPlayer className="effect" src={RES_PATH + "svga/4输出弹窗氛围.svga"} />
      <div className="bg"/>
      <div className="rankText">最终排名为{data?.rank}</div>
      <img className="prizeImg" src={data?.prizeImg} />
      <div className="prizeText">{data?.prizeName}</div>
      <Button className="happy md25" onClick={this.clickClose} />
      <Button className="close" onClick={this.clickClose} />
    </div>;
  }
}

export default RankPrizePop;
