import { PAGE_MAP } from "@src/utils/constants";
import { makeAutoObservable } from "mobx";
import API from "../api/index";
import { GetCurrSkinId, getCustomShareId, getUrlParam, waitTime } from "@src/utils/utils";
import { Toast } from "@spark/ui";
import modalStore from "@src/store/modal";
import shareStore from "./share";

const skinId = GetCurrSkinId() || getCustomShareId();

const store = makeAutoObservable({
  /** 活动规则 */
  ruleInfo: "",

  /** 前端开发配置 */
  frontVariable: {},

  /** 当前页面 */
  curPage: (CFG.agentShare == "1" ? PAGE_MAP.AGENT_SHARE_PAGE : null) || {
    // TODO 举例子，自定义页面，因为mng更新原因原数字id会对应一个新的字符串id
    "5055": "sharePage",
    Did1NDA0NDc: "sharePage",
    prize: PAGE_MAP.PRIZE_PAGE,
    sharePage: PAGE_MAP.SHARE_PAGE,
    index: PAGE_MAP.HOME_PAGE,
  }[skinId] || PAGE_MAP.HOME_PAGE,

  prevPage: [],

  pageData: {},

  /** 场景切换 */
  changePage(page, data = {}) {
    this.prevPage.push(this.curPage);
    this.pageData = data;
    this.curPage = page;
  },

  backPage() {
    if (this.prevPage.length === 0) return;
    this.curPage = this.prevPage.pop();
  },

  /** 绑定友客业务员 */
  async bindYkCode(code) {
    const res = await API.bindYk({
      code: code,
    });
    return res;
  },
  //分享活动
  shareAct() {
    shareStore.doShare();
  },

  homeInfo: {},

  /** 获取活动规则 */
  async initRule() {
    // 模拟获取远程的数据
    const { data } = await API.getRule();
    this.ruleInfo = data;
  },

  /** 获取前端配置项 */
  async getFrontVariable() {
    // 获取前端开发配置
    const { data } = await API.getFrontVariable();
    this.frontVariable = data || {};
    console.log("前端开发配置", data);
  },
  /** 绑定手机号接口返回状态 */
  isApiCheckBack: false,
  setIsApiCheckBack(status) {
    this.isApiCheckBack = status;
  },
  /** 校验是否绑定手机号 */
  async checkBindStatus() {
    const { success, data } = await API.checkBind({
      appId: getUrlParam("appId"),
      dbredirect: encodeURIComponent(window.location.href),
    });
    console.info("%c data", "font-size: 30px", data);
    if (success && data) {
      if (data?.bind) {
        if (data?.url) {
          location.replace(data?.url);
        } else {
          // 已经绑定过，跳转完后端返回的免登链接时，展示页面
          this.setIsApiCheckBack(true); // 助力
          return true;
        }
      } else {
        this.setIsApiCheckBack(true);
        modalStore.pushPop("LoginPop");
      }
      await waitTime(200);
    }
    return false;
  },


  setIndex: {},
  /** 首页 */
  async getHomeInfo() {
    const { success, data } = await API.index();
    if (!success) return;
    this.setIndex = data || {};

    if (data?.rulePop) {
      modalStore.pushPop("RulePop");
      this.setIndex.rulePop = false;
    }

    if (data?.newAssistUser) {
      modalStore.pushPop("AssistCountPanel");
    }

    if (data?.carvePop) {
      modalStore.pushPop("CarvePanel");
    }

    // 首页接口把绑定逻辑加上
    /** 绑定业务员code判断 */
    if (data?.boundYkCode) {
      // 已绑定
      if (data?.agent) {
        CFG.workerCode = data?.agentCode;
      } else {
        CFG.workerCode = data?.boundYkCode;
      }
    } else {
      // 未绑定 从链接上取-无论是否有都要调用
      if (!data?.agent) {
        /**后端说增加非业务员才调用 */
        const { success: success1, data: data1 } = await this.bindYkCode(CFG.workerCode || "");

        if (success1 && data1?.code) {
          CFG.workerCode = data1?.code;
        }
      } else {
        CFG.workerCode = data?.agentCode;
      }
    }

    // 排行榜弹窗
    if (this.setIndex?.rankPopInfo) {
      if (this.setIndex.rankPopInfo.boolReward) {
        modalStore.pushPop("RankPrizePop", { data: this.setIndex?.rankPopInfo });
      } else {
        modalStore.pushPop("RankNoPrizePop", { data: this.setIndex?.rankPopInfo });
      }
    }
  },

  /**   判断活动时间 */
  checkActTime(type) {
    const { actStartTimestamp, currentTimestamp, actEndTimestamp } = this.setIndex;
    if (currentTimestamp < actStartTimestamp && !["rule", "prize"].includes(type)) {
      Toast("活动未开始", 2000, {hideOthers: true});
      return false;
    }
    if (currentTimestamp > actEndTimestamp && !["rule", "prize"].includes(type)) {
      Toast("活动已结束", 2000, {hideOthers: true});
      return false;
    }
    return true;
  },

});


export default store;
