'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './sharepage.less';
import { _throttle } from '@src/utils/utils';
import { extranceName } from '@src/utils/constants';
import shareStore from '@src/store/share';
import { LOG_KEY, MatterShareOpt, MatterViewOpt, sensorLog } from '@src/utils/sensors';
import { Button } from "@src/components/Button";
@observer
class AgentSharepage extends React.Component {
  constructor(props) {
    super(props);
    this.shareRef = null;
  }

  async componentDidMount() {

    MatterViewOpt("b12850", {
      page_name: "分享落地页",
    });

    sensorLog(LOG_KEY.exposure, "b12850", "d12853", {
      button_name: "分享活动按钮",
      page_name: "分享落地页",
    });

  }

  handleShareAct = _throttle(() => {

    MatterShareOpt("b12850", "d12853", {
      button_name: "分享活动按钮",
      page_name: "分享落地页",
    });
    shareStore.doShare();
  })

  render() {
    return (
      <div className="agentsharepage_wrap" ref={r => this.shareRef = r}>
        <div className="sharepage modal_center">
          <span className="bg"></span>
          <Button className="normal_btn md32" onClick={this.handleShareAct}></Button>
        </div>
      </div>
    );
  }
}
export default AgentSharepage;
