"use strict";

import React from "react";
import { observer } from "mobx-react";
import "./yinsirulepop.less";
import store from "@src/store";
import API from "@src/api";
import { _asyncThrottle } from "@src/utils/utils";
import modalStore from "@src/store/modal";
import { PAGE_MAP } from "@src/utils/constants";
import { Button } from "@src/components/Button";

@observer
class Yinsirulepop extends React.Component {
  constructor(props) {
    super(props);
  }

  clickClose = () => {
    modalStore.closePop("Yinsirulepop");
  };

  clickTo = _asyncThrottle(async () => {
    const { success } = await API.agreePrivacy();
    if (!success) return;
    store.changePage(PAGE_MAP.PRIZE_PAGE);
    store.getHomeInfo();
    modalStore.closePop("Yinsirulepop");
  });

  render() {
    return (
      <div className="yinsirulepop modal_center">
          <span className="bg">
              <div className="ruletext"
                   dangerouslySetInnerHTML={{ __html: store.frontVariable?.privacyText }}
              />
          </span>
        <Button className="close" onClick={this.clickClose}></Button>
        <Button className="btn md29" onClick={this.clickTo}></Button>
      </div>
    );
  }
}

export default Yinsirulepop;
