import { Toast } from "@spark/ui";
import store from ".";
import { callApi } from "@spark/api-base";
import { getDomain } from "@spark/dbdomain";

/** 判断活动状态 */
export const judgeActivity = (arr = ['start', 'end']) => {
  const { currentTimestamp, actStartTimestamp, actEndTimestamp } = store?.homeInfo || {};
  if (currentTimestamp < actStartTimestamp && arr.includes("start")) {
    Toast("活动未开始", 2000, {hideOthers: true});
    return false;
  } else if (currentTimestamp > actEndTimestamp && arr.includes("end")) {
    Toast("活动已结束", 2000, {hideOthers: true});
    return false;
  }
  return true;
};

/** 处理cookie */
export const saveCookies = async () => {
  // const strCookie = document.cookie;
  // localStorage.setItem("userCookies", strCookie);
  // console.info(`%c 设置cookies: ${strCookie}`, "font-size: 20px");
  const domain = await getDomain();
  const data = await callApi(`${domain}/autoLogin/tempSaveCookie`);
  console.info(`%c cookieId: ${data}`, "font-size: 20px; color: orange");
  if (!!data) {
    localStorage.setItem("cookieId", data);
  }
};

/** 设置cookies */
export const setCookies = async () => {
  // alert(1)
  // console.info("setCookies执行")
  // console.info("setCookies1")
  const cookieId = localStorage.getItem("cookieId");
  const domain = await getDomain();
  // console.info("setCookies2")
  if (!!cookieId) {
    // console.info("setCookies3")
    await callApi(`${domain}/autoLogin/resetCookie?duibaTempCookieId=${cookieId}`);
    localStorage.removeItem("cookieId");
    // console.info("setCookies4")
  }
};
