import {
  globalData
} from "./globalData"

const requestFun = async (dataSouce) => {
  // wx.showLoading({
  //   mask: true
  // })
  console.log(dataSouce, "dataSouce")
  return await new Promise((resolve, reject) => {

    getApp().getSdk().request({
      url: dataSouce.url, // 接口名称相对地址
      data: {
        ...dataSouce.data
      }, // 接口所需数据
      requestOption: {
        header: {
          ...dataSouce.header,
          "cloud-app-id": "612072719085-yxh-login", // 开发者接口所在容器应用的环境域名前缀。配置错误会导致HTTP请求404。
        },
        method: dataSouce.method
      }
    }).then(res => {
      if (res.code == '90002') {
        /**token失效，重新登陆 */
        // await login(globalData.wid)
        wx.showToast({
          title: '获取数据失败，请重新进入吧~',
          icon: "none"
        })
      }
      console.warn('收到接口返回值:' + dataSouce.url, res)
      resolve(res);
    })

  })
}

export default requestFun;


const login = async (wid) => {
  await new Promise((r) => {
    wx.login({
      success: ress => {
        reqDbLogin({
          code: ress.code,
          wid
        }).then((respp) => {
          if (respp) {
            globalData.loginToken = encodeURIComponent(respp.data.loginToken)
            r(1)
          }
        })
      }
    })
  })
}