import {
  globalData
} from "../../utils/db_api/globalData";
import {
  apiUploadFile,
  reqDbLogin
} from "../../utils/db_api/index";
const defaultAvatarUrl = 'https://mmbiz.qpic.cn/mmbiz/icTdbqWNOwNRna42FI242Lcia07jQodd2FJGIYQfG0LAJGFxM4FbnQP6yfMxBgJ0F3YRqJCJ1aPAK2dQagdusBZg/0'

const app = getApp()
Component({

  data: {
    isloading: false,
    avatarUrl: defaultAvatarUrl,
    nickName: "",
  },

  properties: {
    isBindPhone: Boolean
  },

  attached() {
    console.log(this)
    console.error("看看文案", this.data, this.data.isBindPhone)
  },

  methods: {
    onModalClose() {
      this.triggerEvent("onModalClose", 'clickGift');
    },
    onChooseAvatar(e) {
      console.warn("eee", e)
      const {
        avatarUrl
      } = e.detail;
      console.log(e, "头像")
      // this.setData({
      //   avatar: avatarUrl,
      // })
      wx.getFileSystemManager().readFile({
        filePath: e.detail.avatarUrl, //地址
        encoding: 'base64', //编码格式
        success: res => {
          let base64 = 'data:image/png;base64,' + res.data
          apiUploadFile({
            img64: base64,
          }).then((res = {}) => {
            console.warn(JSON.stringify(res), "resttts");
            this.setData({
              avatarUrl: res.data
            })
          })
        }
      })
    },
    onInputChange(e) {
      console.warn("nickName", e.detail.value)
      this.setData({
        nickName: e.detail.value
      })
    },
    checkAuth(e) {
      /**未绑定手机号，先绑定 */
      wx.login({
        success: res => {
          if (res.code) {
            const param = {
              code: res.code,
              phoneEncryptedData: e.detail.encryptedData,
              phoneIv: e.detail.iv,
            }
            this.login_db(param)
          } else {
            console.log('获取用户登录态失败！' + res.errMsg)
          }
        }
      })

    },
    saveFunc(e) {
      this.triggerEvent("onSaveFunc", {
        nickName: this.data.nickName,
        avatarUrl: this.data.avatarUrl
      })
    },
    cancelFunc(e) {
      this.triggerEvent("onCancelFunc", e)
    }
  }

})