const SYSTEM_PAGE_PATH_LIST = [
  'goodsDetail',
  'shopCart',
  'userCenter',
  'orderList',
  'orderDetail',
  'orderExpress',
  'userSettings',
  'accountSettings',
  'cardPackages',
  'userCouponList',
  'pointMall',
  'salesmanCenter',
  'refundList'
]
const navigate = require('./navigate')
/**
 *
 * @param {Object} option 跳转参数
 * @param {string} option.url 跳转地址
 * @param {Object} option.query 跳转携带参数
 * @param {string} option.method [navigateTo,redirectTo,reLaunch,navigateBack]
 */
module.exports = function (option) {
  if (SYSTEM_PAGE_PATH_LIST.indexOf(option.url) < 0) {
    console.error('请传入正确的页面标识,支持跳转的页面请参考文档')
    return
  }
  navigate[option.url](option.method, option.query)
}
