// import retailApi from './utils/retail.api'
const EXTENDS_PAGE_LIST = [

  'pages/goods/detail',
  'pages/goods/searchResult/index',
  'pages/shop/cart',
  'pages/order/create/index',
  'pages/order/detail/paidstatus',
  'pages/order/detail/detail',
  'pages/user/guide/myguide',
  'pages/user/membership/index',
  'pages/tabbar/goods/list',
  'pages/tabbar/goods/classify',
  'pages/tabbar/user/center'

]

const { login, loginByPhone } = require('./utils/auth')
const WeimobCore = require('./utils/core')
const request = require('./utils/request')
const { relationChain, userPhone } = require('./utils/paas')
const navigator = require('./utils/navigator')
const retailApi = require('./utils/retail.api')
const { downloadFile } = require('./utils/file')

class WeimobJsSdk {
  constructor () {
    this.login = login
    this.loginByPhone = loginByPhone
    this.pages = {}
    this.request = request
    this.toPage = navigator
    this._globalData = {}
    this.getRetailData = retailApi // 此处暴露公共数据获取接口
    this.relationChain = relationChain // 导购存关系链
    this.userPhone = userPhone // 会员注册手机号
    this.downloadFile = downloadFile

    this.getStoreId = () => 123456 // 获取storeId
    this.setStoreId = () => { } // 设置storeId
    this.recommendStoreId = () => Promise.resolve({
      errcode: '0',
      errmsg: '处理成功',
      data: {
        url: 'https://100000199446.retail.n.weimob.com/saas/retail/100000199446/26051446/shop/store/preprocess',
        isNewRetailMode: true,
        recommendStoreResultInfo: '',
        storeId: 26051446
      }
    }) // 简易版门店推荐
    this.jumpToStoreList = (url) => console.log('真实环境会跳转到门店列表') // 跳转门店列表， url为回跳地址

    Object.defineProperty(this, 'page', {
      get () {
        return this.$getCurrentPage()
      }
    })
  }

  $getCurrentPage () {
    const pages = getCurrentPages()
    const page = pages[pages.length - 1]
    if (page) {
      if (EXTENDS_PAGE_LIST.indexOf(page.route) >= 0 && !page.core) {
        page.core = new WeimobCore(page)
      }
      return page.core
    }
  }

  $setGlobalData (key, value) {
    this._globalData[key] = value
  }

  $getGlobalData (key) {
    return this._globalData[key]
  }
}

module.exports = WeimobJsSdk
