import {
  globalData
} from "../../utils/db_api/globalData";
import {
  apiDoAssist,
  apiGetShareUserInfo,
  reqDbLogin
} from "../../utils/db_api/index";

const app = getApp()
Component({

  data: {
    isloading: false,
    nickname: "",
    avatar: ""
  },

  properties: {
    isBindPhone: Boolean,
    shareCode: String,
    isAuthUserInfo: Boolean
  },

  async attached() {
    console.log(this)
    console.error("看看文案", this.data, this.data.isBindPhone)
    const getShareUserInfoResp = await apiGetShareUserInfo({
      inviteCode: this.data.shareCode
    })
    if (getShareUserInfoResp.success) {
      this.setData({
        nickname: getShareUserInfoResp.data.nickname,
        avatar: getShareUserInfoResp.data.avatar
      })
    }
  },

  methods: {
    onModalClose() {
      this.triggerEvent("onModalClose", 'assist');
    },
    assistFunc() {
      wx.showLoading()
      console.warn("助力")
      apiDoAssist({
        inviteCode: this.data.shareCode
      }).then((res) => {
        wx.hideLoading()
        this.triggerEvent("onAssistResult", res)
      })
    },
    checkAuthPhone(e) {
      wx.showLoading()
      this.triggerEvent("onAuthPhone", e)
    },
    checkAuthUser(e) {
      // wx.showLoading()
      this.triggerEvent("onAuthUser", e)
    }
  }
})