const path = require("path");
const webpack = require("webpack");
const XappWebpackPlugin = require("xapp-webpack-loader").plugin
const UglifyJsPlugin = require("uglifyjs-webpack-plugin");
const CopyPlugin = require('copy-webpack-plugin');
const basePath = process.cwd()
console.log('b', basePath)
module.exports = {
  mode: 'development',
  target: 'node',
  devtool: false,
  watchOptions: {
    ignored: /node_modules/,
    poll: 1000
  },
  entry: path.resolve(basePath, './src/app.json'),
  output: {
    path: path.resolve(basePath, './dist')
  },
  resolve: {
    alias: {
      src: path.resolve(basePath, './src'),
    }
  },
  resolveLoader: {
    alias: {
      'cache-loader': path.resolve(__dirname, '../node_modules/cache-loader'),
      'babel-loader': path.resolve(__dirname, '../node_modules/babel-loader'),
      'file-loader': path.resolve(__dirname, '../node_modules/file-loader'),
      'xapp-webpack-loader': path.resolve(__dirname, '../node_modules/xapp-webpack-loader'),
    }
  },
  module: {
    rules: [
      {
        test: /\.js$/,
        include: path.resolve(basePath, './src'),
        exclude: path.resolve(basePath, './node_modules'),
        use: [
          'cache-loader',
          'babel-loader',
        ],
      },

      {
        test: /.wxml/,
        use: [
          {
            loader: 'file-loader',
            options: {
              publicPath: '',
              context: path.resolve(basePath, './src'),
              name: '[path][name].[ext]'
            }
          },
          'xapp-webpack-loader',
        ]
      },
      {
        test: /\.wxss$/,
        use: [
          {
            loader: 'file-loader',
            options: {
              publicPath: '',
              context: path.resolve(basePath, './src'),
              name: '[path][name].[ext]'
            }
          },
          'xapp-webpack-loader',
        ]
      },
      {
        test: /.wxs$/,
        use: [
          {
            loader: 'file-loader',
            options: {
              publicPath: '',
              context: path.resolve(basePath, './src'),
              name: '[path][name].[ext]'
            }
          },
          'babel-loader',
          'xapp-webpack-loader',
        ]
      },
      {
        test: /\.json/,
        type: 'javascript/auto',
        use: [
          {
            loader: 'file-loader',
            options: {
              publicPath: '',
              context: path.resolve(basePath, './src'),
              name: '[path][name].[ext]'
            }
          },
          'xapp-webpack-loader'
        ]
      },
      {
        test: /\.(png|jpg|jpeg|gif)$/,
        include: /src/,
        use: [
          {
            loader: 'file-loader',
            options: {
              publicPath: '',
              context: path.resolve(basePath, './src'),
              name: '[path][name].[ext]'
            }
          }
        ]
      }
    ]
  },
  optimization: {
    minimizer: [
      new UglifyJsPlugin({
        uglifyOptions: {
          compress: {
            drop_console: true
          },
          output: {
            comments: false
          }
        }
      })
    ],
    // minimize: false,
    concatenateModules: false,
    splitChunks: {
      cacheGroups: {
        commons: {
          test: (module) => !/[\\/]mock[\\/]/.test(module.resource),
          name: 'weimob-cloud-commons',
          chunks: 'initial',
          minSize: 0,
          minChunks: 2,
          priority: 1,
          maxInitialRequests: 10
        },
        vendors: {
          test: module => !module.isEntryModule() && /\.js$/.test(module.resource) && /[\\/]node_modules[\\/]/.test(module.resource),
          name: 'weimob-cloud-vendors',
          chunks: 'all',
          maxInitialRequests: 10,
          priority: 1
        }
      }
    }
  },
  plugins: [
    new webpack.DefinePlugin({
      PRODUCTION: JSON.stringify(process.env.NODE_ENV === 'production')
    }),

    new CopyPlugin({
      patterns: [
        {
          from: path.resolve(basePath, './src/sitemap.json'),
          to: path.resolve(basePath, './dist/sitemap.json')
        }
      ],
    }),
    new XappWebpackPlugin({
      mainComponentDirs: [
        'cloud-components',
        'components'
      ]
    })
  ]
}