
const __baseURL = 'https://612072719085-yxh-login.app.weimobcloud.com'
//const __baseURL = 'https://612072719085-yxh-login.appdev.weimobcloud.com'

/**
 * @method 发送请求
 *
 * @param {Object} option - 请求配置参数
 * @param {string} option.url - 请求路径
 * @param {Object} option.data - 请求参数
 * @param {Object} option.requestOption - 请求配置（参考wx.request 官方文档 https://developers.weixin.qq.com/miniprogram/dev/api/network/request/wx.request.html）
 *
 * @returns {Promise}
 */

module.exports = function (option) {
  return new Promise((resolve, reject) => {
    option.requestOption = option.requestOption || {}
    wx.request({
      url: __baseURL + option.url,
      method: option.requestOption.method || 'POST',
      ...option.requestOption,
      data: {
        wid: '{{wid}}',
        ...option.data
      },
      header: {
        'content-type': 'application/json',
        Accept: 'application/json',
        ...option.requestOption.header
      },
      success: (res) => {
        if (res.statusCode === 200) {
          resolve(res.data)
        } else {
          reject(res)
        }
      },
      fail: res => {
        reject(res)
      }
    })
  })
}
