
/**
 * 导购-写入导购与用户的关系链
 * @options [Object] { "pid":10, "wid":xxxx, "ecBizType":"xxxx", "ecBizTicket":"xxxx" }
 * pid 店铺
 * wid 用户
 * ecBizType 对页面分享链接URL解析后的参数之一
 * ecBizTicket 对页面分享链接URL解析后的参数之一
 *
 * @returns [Promise] {success: true} 返回写入结果
 * success [Boolean] true: 写入成功。false：写入失败。
 **/
export const relationChain = function (options) {
  return new Promise((resolve, reject) => {
    if (options) {
      return resolve({ success: true })
    } else {
      return reject({ success: false })
    }
  })
}

/**
 * 会员注册 - 解析微信加密数据的真实手机号
 * @options [Object]  { encryptedData: 'xxxx', iv:'xxxx' }
 * encryptedData  微信授权手机号按钮button组件点击后的回调值。
 * iv  微信授权手机号按钮button组件点击后的回调值。
 *
 * @returns [Promise] {success: true, phone: 123456}
 **/
export const userPhone = function ({ encryptedData, iv }) {
  return new Promise((resolve, reject) => {
    if (encryptedData && iv) {
      return resolve({ success: true, phone: 123456 })
    } else {
      return reject({ success: false })
    }
  })
}
